//
//  ChosePersonViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/6.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ChosePersonViewController.h"
#import "MaskCell.h"
#import "User.h"
#define TopMargin 50
#define TableHeight 50
@interface ChosePersonViewController ()<UITableViewDataSource,UITableViewDelegate,UITextFieldDelegate>
{
    UITableView *_tableView;
    UITextField *_selectTextFiled;
    NSMutableArray *_dataArr;
    NSMutableArray *_indexArr;
}
@end

@implementation ChosePersonViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initData];
    [self bulidLayout];
}
- (void)initData{
    _dataArr = [NSMutableArray array];
    _indexArr = [NSMutableArray array];
    for (NSInteger i = 0; i < 10; i++) {
        User *user = [[User alloc]init];
        user.userName = [NSString stringWithFormat:@"张三%ld",(long)i];
        [_dataArr addObject:user];
    }
}
- (void)bulidLayout
{
    self.view.backgroundColor = HexColor(@"f8f8f8");
    _selectTextFiled = [[UITextField alloc] initWithFrame:CGRectMake(20,5,ScreenSize.width - 40,TopMargin -10)];
    _selectTextFiled.textAlignment = NSTextAlignmentLeft;
    _selectTextFiled.background = [UIImage imageNamed:@"textFiled"];
    _selectTextFiled.delegate = self; 
    _selectTextFiled.font = FontSize(15);
    [self.view addSubview:_selectTextFiled];
    
    UIImageView *leftView = [[UIImageView alloc]initWithFrame:CGRectMake(0, 0, 35, 40)];
    leftView.image = [UIImage imageNamed:@"search"];
    _selectTextFiled.leftView = leftView;
    _selectTextFiled.leftViewMode = UITextFieldViewModeAlways;
    
    UIButton *rightView = [UIButton buttonWithType:UIButtonTypeCustom];
    [rightView setImage:[UIImage imageNamed:@"delete"] forState:UIControlStateNormal];
    rightView.frame = CGRectMake(0, 0, 35, 40);
    [rightView addTarget:self action:@selector(deletePerson) forControlEvents:UIControlEventTouchUpInside];
    _selectTextFiled.rightView = rightView;
    _selectTextFiled.rightViewMode = UITextFieldViewModeAlways;
    

    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,ScreenSize.width, ScreenSize.height - 64 - TopMargin)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.delegate = self;
    _tableView.dataSource = self;
    [self.view addSubview:_tableView];
    
    
    UIBarButtonItem *rightItem = [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(sureClick)];
    self.navigationItem.rightBarButtonItem = rightItem;
}

- (void)sureClick{
    NSMutableArray *arr = [[NSMutableArray alloc]init];
    for (NSIndexPath *index in _indexArr) {
        User *user = _dataArr[index.row];
        [arr addObject:user];
    }
    self.chosePerson(arr);
    [self PopViewControllerAnimated:YES];
}


- (void)deletePerson {
    _selectTextFiled.text = @"";
    [_indexArr removeAllObjects];
    [_tableView reloadData];
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskCell";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth:ScreenSize.width totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.Commitbtn.hidden = YES;
    }
    if ([self isHaveIndexPath:indexPath]) {
        cell.Commitbtn.hidden = NO;
    }else{
        cell.Commitbtn.hidden = YES;
    }
    if (_dataArr.count > 0) {
        User *user =  _dataArr[indexPath.row];
        [cell setTitleStr:user.userName];

    }
    return cell;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if (self.isMoreChose == YES) {
        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        cell.Commitbtn.hidden = NO;
        if (![self isHaveIndexPath:indexPath]) {
            [_indexArr addObject:indexPath];
        }
        
        NSString *personStr = @"";
        for (NSIndexPath *index in _indexArr) {
            User *user = _dataArr[index.row];
           personStr = [personStr stringByAppendingFormat:@"%@、",user.userName];
        }
        _selectTextFiled.text = personStr;
    }
}

- (BOOL)isHaveIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in _indexArr) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

@end
