//
//  NewSurveyViewController.m
//  XFFurit
//
//  Created by 陈俊俊 on 15/8/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//  新建行情调研



#import "NewSurveyViewController.h"
#import "SurveyCell.h"
#import "HPGrowingTextView.h"
#import "StartTimeView.h"
#import "ChosePersonViewController.h"
#import "ChooseProductViewController.h"
#import "User.h"
#import "Survey.h"
#define LeftMargin 15
#define BtnHeight 44
#define TableHeight 46
#define CornerRadius 5
#define TitleSize 15
#define BtnSize 19
#define TotalHeight 432
#define KeyboardHeight 258
#define DateViewHeight 300
typedef enum : NSUInteger {
    SaveTag = 2000,
    CommitTag,
} BtnTag;

@interface NewSurveyViewController ()<UITableViewDataSource,UITableViewDelegate,HPGrowingTextViewDelegate,UITextFieldDelegate,StartTimeViewDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
    UITextField *_titleField;
    UILabel *_productLabel;
    UILabel *_startDateLabel;
    UILabel *_endDateLabel;
    UILabel *_personLabel;
    HPGrowingTextView *_noteTextView;
    UIDatePicker *_timePicker;
    BOOL _isClickStart;
    StartTimeView *_startTimeView;
}
@property (nonatomic,strong)NSString *surveyTitle;
@property (nonatomic,strong)NSString *productUuid;
@property (nonatomic,strong)NSString *productName;
@property (nonatomic,strong)NSString *beginDate;
@property (nonatomic,strong)NSString *endDate;
@property (nonatomic,strong)NSString *remark;
@property (nonatomic,strong)NSMutableArray *users;

@end

@implementation NewSurveyViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initData];
    [self createTableView];
}
- (void)initData{
    _dataArr = [NSMutableArray array];
    self.users = [NSMutableArray array];
    [_dataArr addObject:@"标题"];
    [_dataArr addObject:@"商品"];
    [_dataArr addObject:@"开始日期"];
    [_dataArr addObject:@"结束日期"];
    [_dataArr addObject:@"调研人员"];
    [_dataArr addObject:@"备注"];
}

- (void)createTableView
{
    self.view.backgroundColor  = XXFBgColor;

    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, LeftMargin,ScreenSize.width, ScreenSize.height - 64 - LeftMargin)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.bounces = NO;
    _tableView.delegate = self;
    _tableView.dataSource = self;
    
    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 50)];
    
    UIButton *saveBtn =  [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, 10, (ScreenSize.width - LeftMargin*3)/2, BtnHeight) target:self sel:@selector(btnClick:) tag:SaveTag image:nil title:@"保存" titleColor: [UIColor whiteColor] isCorner:YES corner:CornerRadius bgColor:HexColor(@"50bd62")];
    [footView addSubview:saveBtn];
    
    UIButton *commitBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(saveBtn.frame.origin.x + saveBtn.frame.size.width + LeftMargin, 10, (ScreenSize.width - LeftMargin*3)/2, BtnHeight) target:self sel:@selector(btnClick:) tag:CommitTag image:nil title:@"提交" titleColor: [UIColor whiteColor] isCorner:YES corner:CornerRadius bgColor:HexColor(@"f69100")];
    [footView addSubview:commitBtn];
    
    [self.view addSubview:footView];
    _tableView.tableFooterView = footView;
    [self.view addSubview:_tableView];
}

#pragma mark - 按钮点击事件
- (void)btnClick:(UIButton *)btn{
    switch (btn.tag) {
        case SaveTag:
        {
            if ([self checkSurvey]) {
                [self saveSurvey];
            }
        }
            break;
        case CommitTag:
        {
        
        }
            break;
        default:
            break;
    }
}
- (BOOL)checkSurvey{
    self.surveyTitle = _titleField.text;
    self.remark = _noteTextView.text;
    if (self.surveyTitle.length == 0 || self.productUuid.length == 0 || self.productName.length == 0 || self.users.count <=0 || self.beginDate.length == 0 || self.endDate.length == 0) {
        UIAlertView *alert = [[UIAlertView alloc]initWithTitle:@"提示信息" message:@"信息不完整" delegate:nil cancelButtonTitle:@"确定" otherButtonTitles:nil, nil];
        [alert show];
        return NO;
    }
    return YES;
}


#pragma mark - 保存
- (void)saveSurvey
{
    //保存
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        NSLog(@"%@",data);
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    NSString *beginDate = [[NSDate date] httpParameterString];
    NSString *endDate = [[NSDate date] httpParameterString];


    NSDictionary *dict = @{@"uuid":@"sssffff",@"billnumber":@"1111",@"title":@"gdgfd",@"productUuid":@"gdgfdgd",@"productCode":@"11111",@"productName":@"gfdgfds",@"beginDate":beginDate,@"endDate":endDate,@"remark":@"范德萨范德萨",@"users":self.users};
    [IBTLoadingView showProgressLabel:@"正在保存..."];
    [[ICRHTTPController sharedController] saveSurveyWithAuthenticode:dict success:succ failure:fail];
}


#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    SurveyCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (indexPath.row >0 && indexPath.row < _dataArr.count - 1) {
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
        [self createViewInCell:cell indexPath:indexPath];
    }
    [cell setTitleStr:_dataArr[indexPath.row]];
    return cell;
}

-  (void)createViewInCell:(SurveyCell *)cell indexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 0) {
        _titleField = [[UITextField alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight)];
        _titleField.textAlignment = NSTextAlignmentRight;
        _titleField.textColor = HexColor(@"444444");
        _titleField.placeholder = @"输入调研标题";
        _titleField.font = FontSize(15);
        _titleField.returnKeyType = UIReturnKeyDone;
        _titleField.delegate = self;
        [cell.contentView addSubview:_titleField];

    }else if (indexPath.row == _dataArr.count -1){
        _noteTextView = [[HPGrowingTextView alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight)];
        _noteTextView.contentInset = UIEdgeInsetsMake(5, 5, 5, 0);
        _noteTextView.minNumberOfLines = 1;
        _noteTextView.maxNumberOfLines = 4;
        _noteTextView.font = FontSize(15);
        _noteTextView.textAlignment = NSTextAlignmentRight;
        _noteTextView.delegate = self;
        _noteTextView.returnKeyType = UIReturnKeyDone;
        _noteTextView.placeholder = @"输入备注内容";
        [cell.contentView addSubview:_noteTextView];
        
        CGRect lineFrame =  cell.lineLabel.frame;
        lineFrame.origin.y = TableHeight*2-1;
        cell.lineLabel.frame = lineFrame;
    }else{
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:(CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight))];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = HexColor(@"bbbbbb");
        contentLabel.font = FontSize(TitleSize);
        [cell.contentView addSubview:contentLabel];
        if (indexPath.row == 1) {
            contentLabel.text = @"选择商品";
            _productLabel = contentLabel;
            
        }else if(indexPath.row == 2){
            contentLabel.text = @"选择日期";
            _startDateLabel = contentLabel;

        }else if(indexPath.row == 3){
            contentLabel.text = @"选择日期";
            _endDateLabel = contentLabel;

        }else if(indexPath.row == 4){
            contentLabel.text = @"选择调研人员";
            _personLabel = contentLabel;

        }
    }
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 5){
        return TableHeight*2;
    }else{
        return TableHeight;
    }
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 2 || indexPath.row == 3) {
        [self keyboardHidden];
        if (indexPath.row == 2) {
            _isClickStart = YES;
        }else{
            _isClickStart = NO;
        }
        [self startDatePickView];
    }else if(indexPath.row == 4){
        ChosePersonViewController *cvc = [ChosePersonViewController new];
        cvc.chosePerson = ^(NSArray *users){
            NSString *textStr = @"";
            if (self.users.count <=0) {
                [self.users removeAllObjects];
            }
            for (User *user in users) {
               textStr = [textStr stringByAppendingFormat:@"%@、",user.userName];
                [self.users addObject:[user dictForCommit]];
            }
            _personLabel.text = textStr;
            _personLabel.textColor = HexColor(@"444444");
        };
        cvc.isMoreChose = YES;
        [self PushViewController:cvc animated:YES];
    }else  if(indexPath.row == 1){
        ChooseProductViewController *cvc = [ChooseProductViewController new];
        cvc.choseProduct = ^(NSString *name){
            _productLabel.text = name;
            _productLabel.textColor = HexColor(@"444444");
            self.productName = name;
            self.productUuid = name;
        };
        cvc.isMoreChose = NO;
        [self PushViewController:cvc animated:YES];
    }
}

- (void)startDatePickView{
    if (!_startTimeView) {
        _startTimeView = [[StartTimeView alloc] initWithFrame:CGRectMake(0, ScreenSize.height, ScreenSize.width, ScreenSize.height - 64)];
        _startTimeView.delegate = self;
        _startTimeView.backgroundColor        = RGBA(0, 0, 0 ,0.5);
        [self.view addSubview:_startTimeView];
        
        [UIView animateWithDuration:0.15 animations:^{
            CGRect startFrame =  _startTimeView.frame;
            startFrame.origin.y =  0;
            _startTimeView.frame = startFrame;
        } completion:^(BOOL finished) {
            
        }];
    }
}

- (void)cancelTimeView{
    [self clearDatePickView];
}
- (void)okTimeView:(NSDate *)time{
    NSDateFormatter *df = [[NSDateFormatter alloc] init];
    df.dateFormat       = @"yyyy年MM月dd日";
    if (_isClickStart) {
        _startDateLabel.textColor = HexColor(@"444444");
        _startDateLabel.text = [df stringFromDate:time];
        self.beginDate = [df stringFromDate:time];
    }else{
        _endDateLabel.textColor = HexColor(@"444444");
        _endDateLabel.text = [df stringFromDate:time];
        self.endDate = [df stringFromDate:time];
    }
    // 关闭选择器
    [self clearDatePickView];
}
#pragma mark - 取消
- (void)clearDatePickView{
    [UIView animateWithDuration:0.15 animations:^{
        CGRect startFrame =  _startTimeView.frame;
        startFrame.origin.y = ScreenSize.height;
        _startTimeView.frame = startFrame;
    } completion:^(BOOL finished) {
        [_startTimeView removeFromSuperview];
        _startTimeView = nil;
    }];
}

#pragma mark delegate
- (BOOL)growingTextViewShouldReturn:(HPGrowingTextView *)growingTextView{
    [_noteTextView resignFirstResponder];
    [self setTableFrame:LeftMargin];
    return YES;
}
- (void)growingTextViewDidBeginEditing:(HPGrowingTextView *)growingTextView{
    CGFloat offset = ScreenSize.height - TotalHeight - KeyboardHeight;
    if (offset < 0) {//上移
        [self setTableFrame:LeftMargin+offset];
    }
}
- (void)setTableFrame:(CGFloat)tabelH{
    [UIView animateWithDuration:0.25 animations:^{
        CGRect tableFrame = _tableView.frame;
        tableFrame.origin.y = tabelH;
        _tableView.frame = tableFrame;
    }];
}

- (void)keyboardHidden{
    [_titleField resignFirstResponder];
    [_noteTextView resignFirstResponder];
    [self setTableFrame:LeftMargin];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
@end
