//
//  ResultDetailViewController.m
//  XFFruit
//
//  Created by n22 on 15/8/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ResultDetailViewController.h"
#import "SurveyResult.h"
#import "SurveyResultCell.h"
#define TableHeight 150
@interface ResultDetailViewController ()<UITableViewDataSource,UITableViewDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
}
@end

@implementation ResultDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self initData];
    [self createTableView];
}

- (void)initData{
    _dataArr = [NSMutableArray array];
    for (NSInteger i = 0; i < 4; i++) {
        SurveyResult *survey = [[SurveyResult alloc]init];
        survey.unit = @"南汇8424西瓜调研情况";
        survey.place = @"150605000001";
        survey.price = @"南汇842[100213]";
        survey.capacity = @"22222222222";
        survey.quality = @"费卡接口";
        [_dataArr addObject:survey];
    }
}

- (void)createTableView{
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, 0,ScreenSize.width, ScreenSize.height - 64)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.delegate = self;
    _tableView.dataSource = self;
    [self.view addSubview:_tableView];
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"SurveyResultCell";
    SurveyResultCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyResultCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if (_dataArr.count > 0) {
        SurveyResult *survey = _dataArr[indexPath.row];
        cell.surveyResult = survey;
        
    }
    return cell;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
