//
//  SurveyDetailViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "SurveyDetailViewController.h"
#import "ResultDetailViewController.h"
#define BottomHeight 50
#define LeftMargin 20
#define LeftWidth 100
#define LeftHeight 30



typedef enum : NSUInteger {
    DetailTag = 6000,
    EndTag,
} BtnTag;

@interface SurveyDetailViewController ()
{
    UIScrollView *_scrollView;
    UIView *_surveyView;
    UIView *_bottomView;
}
@property (nonatomic,strong)UILabel *noteLabel;
@end

@implementation SurveyDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self bulifLayout];
}

#pragma mark - 视图初始化
- (void)bulifLayout{
    self.view.backgroundColor = HexColor(@"f8f8f8");

    _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, ScreenSize.height - 64 - BottomHeight)];
    _scrollView.showsHorizontalScrollIndicator  = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    [self.view addSubview:_scrollView];
    
    
    UIButton *endBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, ScreenSize.height  - 64 - BottomHeight +5, ScreenSize.width - LeftMargin*2, 40) target:self sel:@selector(btnClick:) tag:EndTag image:nil title:@"结束" titleColor:[UIColor whiteColor] isCorner:YES corner:8 bgColor:HexColor(@"f69100")];
    [self.view addSubview:endBtn];
    

    _surveyView= [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, LeftHeight*9+LeftMargin/2)];
    _surveyView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_surveyView];
    
    UILabel *tagLabel = [[UILabel alloc]initWithFrame:CGRectMake(LeftMargin/2, 10, LeftWidth*2, LeftHeight)];
    tagLabel.text = @"【调研内容】";
    tagLabel.font =  FontSize(17);
    tagLabel.textColor = [UIColor blueColor];
    [_surveyView addSubview:tagLabel];
    
    NSArray *leftArr = @[@"单号:",@"状态:",@"标题:",@"商品:",@"开始日期:",@"截止日期:",@"调研人员:",@"备注:"];
    NSMutableArray *contentArr = [[NSMutableArray alloc]init];
    [contentArr addObject:self.survey.billnumber];
    [contentArr addObject:self.survey.state];
    [contentArr addObject:self.survey.title];
    [contentArr addObject:self.survey.productname];
    [contentArr addObject:[IBTCommon stringFromDate:self.survey.begindate]];
    [contentArr addObject:[IBTCommon stringFromDate:self.survey.enddate]];
    [contentArr addObject:self.survey.productcode];
    [contentArr addObject:self.survey.remark];
    
    for (NSInteger i = 0 ; i < leftArr.count; i++) {
        UILabel *leftLabel = [[UILabel alloc]initWithFrame:CGRectMake(LeftMargin, CGRectGetMaxY(tagLabel.frame) + LeftHeight *i, LeftWidth, LeftHeight)];
        leftLabel.text = leftArr[i];
        leftLabel.font = FontSize(17);
        [_surveyView addSubview:leftLabel];
        
        UILabel *rightLabel = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(leftLabel.frame), CGRectGetMaxY(tagLabel.frame) + LeftHeight *i, _surveyView.frame.size.width - LeftMargin - LeftWidth, LeftHeight)];
        rightLabel.text = contentArr[i];
        rightLabel.font = FontSize(17);
        if (i == leftArr.count - 1) {
            rightLabel.numberOfLines = 0;
            self.noteLabel = rightLabel;
        }
        [_surveyView addSubview:rightLabel];
    }
    
    _bottomView= [[UIView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_surveyView.frame), ScreenSize.width, 200)];
    _bottomView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_bottomView];
    
    UILabel *resultLabel = [[UILabel alloc]initWithFrame:CGRectMake(LeftMargin/2, 10, LeftWidth*2, LeftHeight)];
    resultLabel.text = @"【行情反馈】";
    resultLabel.font =  FontSize(17);
    resultLabel.textColor = [UIColor blueColor];
    [_bottomView addSubview:resultLabel];
    
    UIButton *btn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(CGRectGetWidth(_bottomView.frame) - 100, 10, 100, LeftHeight) target:self sel:@selector(btnClick:) tag:DetailTag image:nil title:@">>查看详情" titleColor:[UIColor blueColor] isCorner:NO corner:0 bgColor:nil];
    [_bottomView addSubview:btn];
    
    [self setNoteHeight];
}

- (void)btnClick:(UIButton *)btn{
    if (btn.tag == DetailTag) {
        ResultDetailViewController *rvc = [ResultDetailViewController new];
        
    
        [self PushViewController:rvc animated:YES];
        
    }else if (btn.tag == EndTag){
        
    }
}

- (void)setNoteHeight
{
    CGFloat height =  [self.noteLabel calculateHeight];
    
    CGRect noteFrame = self.noteLabel.frame;
    noteFrame.size.height = height;
    self.noteLabel.frame = noteFrame;
    
    CGFloat totalHeight = height + LeftHeight*9;
    CGRect surveyFrame = _surveyView.frame;
    surveyFrame.size.height = totalHeight;
    _surveyView.frame = surveyFrame;
    
    
    CGRect bottomFrame = _bottomView.frame;
    bottomFrame.origin.y = CGRectGetMaxY(_surveyView.frame);
    _bottomView.frame = bottomFrame;
    
    _scrollView.contentSize = CGSizeMake(ScreenSize.width, totalHeight + CGRectGetHeight(_bottomView.frame));
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}
@end
