//
//  SurveyViewController.m
//  XFFurit
//
//  Created by 陈俊俊 on 15/8/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "SurveyViewController.h"
#import "SurveyListCell.h"
#import "Survey.h"
#import "SortMaskView.h"
#import "BoltMaskView.h"
#import "SurveyDetailViewController.h"


#define TopMargin 44
#define TableHeight 120
#define LeftMargin 20
#define BtnWidth 60
#define BtnHeight 24
#define BtnSize 16
typedef enum : NSUInteger {
    SortTag = 3000,
    BoltTag
  
} BtnTag;

@interface SurveyViewController ()<UITableViewDataSource,UITableViewDelegate,BoltMaskViewDelegate,SortMaskViewDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
    UIView *_maskView;
    UIButton *currentBtn;
    SortMaskView *_sortView;
    BoltMaskView *_boltView;
    UIBarButtonItem  *_sureBtn;
    UIButton *_sortBtn;
    UIButton *_boltBtn;
}
@end

@implementation SurveyViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"行情调研";
    [self initData];
    [self createTableView];    
}

- (void)initData{
    _dataArr = [NSMutableArray array];
    for (NSInteger i = 0; i < 4; i++) {
        Survey *survey = [[Survey alloc]init];
        survey.title = @"南汇8424西瓜调研情况";
        survey.billnumber = @"150605000001";
        survey.productname = @"南汇842[100213]";
        survey.productcode = @"22222222222";
        survey.remark = @"费卡接口浪格可放大文化大fdsaf缴费卡接口浪费缴费卡上就付款放假快乐撒即可书法家开发商";
        survey.begindate = [IBTCommon convertToDateFrom:@"2015.05.25"];
        survey.enddate = [IBTCommon convertToDateFrom:@"2015.08.06"];
        [_dataArr addObject:survey];
        if (i == 0) {
            survey.state  = @"saved";
        }else if (i == 1) {
            survey.state  = @"submitted";
        }else if (i == 2) {
            survey.state  = @"insurvey";
        }else if (i == 3) {
            survey.state  = @"finished";
        }
    }
}
- (void)createTableView
{
    _sureBtn = [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(sureClick)];
    _sortBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, 10, BtnWidth, BtnHeight) target:self sel:@selector(sortClick:) tag:SortTag image:@"black_arrow_down_with_text" title:nil titleColor:HexColor(@"888888") isCorner:NO corner:0 bgColor:nil];
    _sortBtn.titleLabel.font = FontSize(BtnSize);
    [self.view addSubview:_sortBtn];
    
    _boltBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(ScreenSize.width-BtnWidth - LeftMargin,10,BtnWidth, BtnHeight) target:self sel:@selector(sortClick:) tag:BoltTag image:@"black_filter_with_text" title:nil titleColor:HexColor(@"888888") isCorner:NO corner:0 bgColor:nil];
    _boltBtn.titleLabel.font = FontSize(BtnSize);
    [self.view addSubview:_boltBtn];
    
    
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,ScreenSize.width, ScreenSize.height - 64 - TopMargin)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.delegate = self;
    _tableView.dataSource = self;
    [self.view addSubview:_tableView];
    
    _maskView = [[UIView alloc]initWithFrame:CGRectMake(0, TopMargin, ScreenSize.width, ScreenSize.height - 64- TopMargin)];
    _maskView.backgroundColor = RGBA(0, 0, 0, 0.5);
    _maskView.hidden = YES;
    [self.view addSubview:_maskView];
}

#pragma mark - 确定
- (void)sureClick{
    if (_sortView) {
        [self hiddenSortMaskView:YES];
    }
    if (_boltView) {
        [self hiddenBoltMaskView:YES];
    }
    self.navigationItem.rightBarButtonItem = nil;
}

#pragma mark -按钮事件
- (void)sortClick:(UIButton *)btn{
    _maskView.hidden = NO;
    if (btn.tag == SortTag) {
        if(_boltView){
            [self hiddenBoltMaskView:NO];
        }
        if (currentBtn == btn) {
            [btn setImage:[UIImage imageNamed:@"black_arrow_down_with_text"] forState:UIControlStateNormal];
            [self hiddenSortMaskView:YES];
            currentBtn = nil;
            self.navigationItem.rightBarButtonItem = nil;
        }else{
            [btn setImage:[UIImage imageNamed:@"select_arrow_up"] forState:UIControlStateNormal];
            if (_sortView == nil) {
                _sortView = [[SortMaskView alloc]initWithFrame:CGRectMake(0, -105, ScreenSize.width, 105)];
                _sortView.dataArr = [[NSMutableArray alloc]initWithObjects:@"默认排序",@"默认排序",@"默认排序" ,nil];
                _sortView.delegate = self;
                [_maskView addSubview:_sortView];
                [UIView animateWithDuration:0.25 animations:^{
                    CGRect sortFrame = _sortView.frame;
                    sortFrame.origin.y = 0;
                    _sortView.frame = sortFrame;
                }];
            }
            self.navigationItem.rightBarButtonItem = _sureBtn;
            currentBtn = btn;
        }
    }else if(btn.tag == BoltTag){
        if (_sortView) {
            [self hiddenSortMaskView:NO];
        }
        if (currentBtn == btn) {
            [btn setImage:[UIImage imageNamed:@"black_filter_with_text"] forState:UIControlStateNormal];
            [self hiddenBoltMaskView:YES];
            currentBtn = nil;
            self.navigationItem.rightBarButtonItem = nil;

        }else{
            [btn setImage:[UIImage imageNamed:@"selected-filter_with_text"] forState:UIControlStateNormal];
            if (_boltView == nil) {
                _boltView = [[BoltMaskView alloc]initWithFrame:CGRectMake(0, -105, ScreenSize.width, 176)];
                _boltView.backgroundColor = HexColor(@"f8f8f8");
                _boltView.delegate = self;
                _boltView.dataArr = [[NSMutableArray alloc]initWithObjects:@"默认排序1",@"默认排序1",@"默认排序1" ,nil];
                [_maskView addSubview:_boltView];
                [UIView animateWithDuration:0.25 animations:^{
                    CGRect sortFrame = _boltView.frame;
                    sortFrame.origin.y = 0;
                    _boltView.frame = sortFrame;
                }];
                currentBtn = btn;
                self.navigationItem.rightBarButtonItem = _sureBtn;

            }
        }
    }
}

- (void)hiddenSortMaskView:(BOOL)isHide{
    [_sortBtn setImage:[UIImage imageNamed:@"black_arrow_down_with_text"] forState:UIControlStateNormal];
    if (isHide == NO) {
        [_sortView removeFromSuperview];
        _sortView = nil;
    }else{
        [UIView animateWithDuration:0.25 animations:^{
            CGRect sortFrame = _sortView.frame;
            sortFrame.origin.y = -105;
            _sortView.frame = sortFrame;
        }completion:^(BOOL finished) {
            [_sortView removeFromSuperview];
            _sortView = nil;
            _maskView.hidden = YES;
        }];
    }
}
- (void)hiddenBoltMaskView:(BOOL)isHide{
    [_boltBtn setImage:[UIImage imageNamed:@"black_filter_with_text"] forState:UIControlStateNormal];
    if (isHide == NO) {
        [_boltView removeFromSuperview];
        _boltView = nil;
    }else{
        [UIView animateWithDuration:0.25 animations:^{
            CGRect sortFrame = _boltView.frame;
            sortFrame.origin.y = -105;
            _boltView.frame = sortFrame;
        }completion:^(BOOL finished) {
            [_boltView removeFromSuperview];
            _boltView = nil;
            _maskView.hidden = YES;
        }];
    }
}
#pragma mark - sortDelegate
- (void)getSortValueSelectRow:(NSString *)state{
    NSLog(@"%@",state);
}
- (void)getBoltValueSelectRow:(NSString *)state{
    NSLog(@"%@",state);
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"SurveyID";
    SurveyListCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyListCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if (_dataArr.count > 0) {
        Survey *survey = _dataArr[indexPath.row];
        [cell setSurvey:survey];

    }
    return cell;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    SurveyDetailViewController *svc = [SurveyDetailViewController new];
    if (_dataArr.count > 0) {
        svc.survey = _dataArr[indexPath.row];
    }
    [self PushViewController:svc animated:YES];

}



- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
