//
//  ChooseSupplierViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/23.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ChooseVendorViewController.h"
#import "MaskCell.h"
#import "Vendor.h"
#define TopMargin 50
#define TableHeight 50
@interface ChooseVendorViewController ()<UITableViewDataSource,UITableViewDelegate,UITextFieldDelegate>
{
    UITextField *_selectTextFiled;
    NSIndexPath *_currentIndexPath;
    
}
@property (nonatomic,strong)NSMutableArray *dataArr;
@property (nonatomic,strong)UITableView *tableView;
@property (nonatomic,strong)NSMutableArray *indexArr;
@end

@implementation ChooseVendorViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initData];
    [self bulidLayout];
}
- (void)initData{
    self.dataArr = [NSMutableArray array];
    self.indexArr = [NSMutableArray array];
    Vendor *v = [[Vendor alloc]init];
    v.name = @"dddd";
    v.code = @"1111";
    [self.dataArr addObject:v];
    [self fetchVendorList];
    
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            __strong __typeof(weakSelf)strongSelf = weakSelf;
            [strongSelf fetchVendorList];
        }else{
            [IBTLoadingView showTips:data];
        }
    };
    
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getVendorWithPage_number:0 page_size:100 success:succ failure:fail];
}

#pragma mark -成功
- (void)fetchVendorList{
    ICRDatabaseFetchBlock fetchBlk = ^FMResultSet *(FMDatabase *db) {
        NSString * sql = [NSString stringWithFormat:@"SELECT * FROM %@ ORDER BY %@", [Vendor TableName], @"uuid"];
        return [db executeQuery:sql];
    };
    
    __weak typeof(self)weakSelf = self;
    ICRDatabaseFetchResultsBlock fetchResultsBlk = ^(NSArray *fetchedObjects) {
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        [strongSelf.dataArr removeAllObjects];
        [strongSelf.dataArr addObjectsFromArray:fetchedObjects];
        [strongSelf.tableView reloadData];
    };
    
    ICRDataBaseController *dbCtrl = [ICRDataBaseController sharedController];
    [dbCtrl runFetchForClass:[Vendor class]
                  fetchBlock:fetchBlk
           fetchResultsBlock:fetchResultsBlk];
}


#pragma mark - 插入数据


- (void)bulidLayout
{
    self.view.backgroundColor = HexColor(@"f8f8f8");
    _selectTextFiled = [[UITextField alloc] initWithFrame:CGRectMake(20,5,ScreenSize.width - 40,TopMargin -10)];
    _selectTextFiled.textAlignment = NSTextAlignmentLeft;
    _selectTextFiled.background = [UIImage imageNamed:@"textFiled"];
    _selectTextFiled.delegate = self;
    _selectTextFiled.font = FontSize(15);
    [self.view addSubview:_selectTextFiled];
    
    UIImageView *leftView = [[UIImageView alloc]initWithFrame:CGRectMake(0, 0, 35, 40)];
    leftView.image = [UIImage imageNamed:@"search"];
    _selectTextFiled.leftView = leftView;
    _selectTextFiled.leftViewMode = UITextFieldViewModeAlways;
    
    UIButton *rightView = [UIButton buttonWithType:UIButtonTypeCustom];
    [rightView setImage:[UIImage imageNamed:@"delete"] forState:UIControlStateNormal];
    rightView.frame = CGRectMake(0, 0, 35, 40);
    [rightView addTarget:self action:@selector(deletePerson) forControlEvents:UIControlEventTouchUpInside];
    _selectTextFiled.rightView = rightView;
    _selectTextFiled.rightViewMode = UITextFieldViewModeAlways;
    
    
    self.tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,ScreenSize.width, ScreenSize.height - 64 - TopMargin)) style:(UITableViewStylePlain)];
    self.tableView.backgroundColor = [UIColor whiteColor];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.view addSubview:self.tableView];
    
    
    UIBarButtonItem *rightItem = [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(sureClick)];
    self.navigationItem.rightBarButtonItem = rightItem;
}

- (void)sureClick{
    if (self.isMoreChose) {
        NSMutableArray *arr = [[NSMutableArray alloc]init];
        for (NSIndexPath *index in self.indexArr) {
            Vendor *vendor = self.dataArr[index.row];
            [arr addObject:vendor];
        }
        self.choseVendor(arr);
        
    }else{
        NSMutableArray *arr = [[NSMutableArray alloc]init];
        if (self.dataArr.count > 0) {
            Vendor *vendor = self.dataArr[_currentIndexPath.row];
            [arr addObject:vendor];
            self.choseVendor(arr);
        }
    }
    [self PopViewControllerAnimated:YES];
}


- (void)deletePerson {
    if (self.isMoreChose) {
        [self.indexArr removeAllObjects];
    }else{
        _currentIndexPath = nil;
    }
    _selectTextFiled.text = @"";
    [self.tableView reloadData];
    
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskCell";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth:ScreenSize.width totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.Commitbtn.hidden = YES;
    }
    if (self.isMoreChose) {
        if ([self isHaveIndexPath:indexPath]) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }else{
        if (_currentIndexPath) {
            if (indexPath.row == _currentIndexPath.row) {
                cell.Commitbtn.hidden = NO;
            }else{
                cell.Commitbtn.hidden = YES;
            }
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }
    if (self.dataArr.count > 0) {
        Vendor *vendor =  self.dataArr[indexPath.row];
         NSString *proStr = [NSString stringWithFormat:@"%@[%@]",vendor.name,vendor.code];
        [cell setTitleStr:proStr];
    }
    return cell;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if (self.isMoreChose == YES) {
        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        cell.Commitbtn.hidden = NO;
        if (![self isHaveIndexPath:indexPath]) {
            [self.indexArr addObject:indexPath];
        }
        
        NSString *personStr = @"";
        for (NSIndexPath *index in self.indexArr) {
            Vendor *vendor = self.dataArr[index.row];
            if (personStr.length == 0) {
                personStr = [personStr stringByAppendingFormat:@"%@",vendor.name];
            }else{
                personStr = [personStr stringByAppendingFormat:@"、%@",vendor.name];
            }
        }
        _selectTextFiled.text = personStr;
    }else{
        MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:_currentIndexPath];
        currentCell.Commitbtn.hidden = YES;
        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        cell.Commitbtn.hidden = NO;
        _currentIndexPath = indexPath;
        
        
        Vendor *vendor = self.dataArr[indexPath.row];
        _selectTextFiled.text = vendor.name;
        
        
    }
}

- (BOOL)isHaveIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in self.indexArr) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
