//
//  NewPurchaseViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/21.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "NewPurchaseViewController.h"
#import "TopPurchaseView.h"
#import "ProductViewController.h"
#import "AddProductViewController.h"
#define TopHeight 328
#define BottomHeight 300
#define SpaceHeight 20
#define BottomViewHeight 60

typedef enum : NSUInteger {
    SaveTag = 8000,
    CommitTag,
} BtnTag;

@interface NewPurchaseViewController ()<TopPurchaseViewDelegate,ProductViewDelegate>
{
    UIScrollView *_scrollView;
    TopPurchaseView *_purchaseView;
    UIView *_bottomView;
    ProductViewController *_pvc ;
    AddProductViewController *_avc;
}
@end

@implementation NewPurchaseViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    //布局
    [self bulidLayout];
}


#pragma mark - 布局
- (void)bulidLayout
{
    self.view.backgroundColor  = XXFBgColor;
    _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0,0, ScreenSize.width, ScreenSize.height- 64 - BottomViewHeight )];
    _scrollView.showsHorizontalScrollIndicator  = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    _scrollView.contentSize = CGSizeMake(ScreenSize.width, TopHeight+ BottomHeight + SpaceHeight*2);
    [self.view addSubview:_scrollView];
    
    
    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, ScreenSize.height - BottomViewHeight - 64, ScreenSize.width, BottomViewHeight)];
    UIButton *saveBtn =  [IBTCustomButtom creatButtonWithFrame:CGRectMake(15, 8, (ScreenSize.width - 15*3)/2, 44) target:self sel:@selector(btnClick:) tag:SaveTag image:nil title:@"保存" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:HexColor(@"50bd62")];
    [footView addSubview:saveBtn];
    
    UIButton *commitBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(CGRectGetMaxX(saveBtn.frame) + 15, 8, (ScreenSize.width - 15*3)/2, 44) target:self sel:@selector(btnClick:) tag:CommitTag image:nil title:@"提交" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:HexColor(@"f69100")];
    [footView addSubview:commitBtn];
    
    [self.view addSubview:footView];

    _purchaseView = [[TopPurchaseView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, TopHeight)];
    _purchaseView.delegate = self;
    [_scrollView addSubview:_purchaseView];
    
    _bottomView = [[UIView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_purchaseView.frame) + 20, ScreenSize.width,BottomHeight)];
    _bottomView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_bottomView];
    
    _pvc = [[ProductViewController alloc]init];
    _pvc.delegate = self;
    _pvc.viewFrame = _bottomView.bounds;
    [_bottomView addSubview:_pvc.view];
    
}

- (void)btnClick:(UIButton *)btn{
    
    
}
#pragma mark - TopPurchaseViewDelegate

- (void)pushNextViewController:(id)vc{
    [self PushViewController:vc animated:YES];
}

#pragma mark - ProductViewDelegate
- (void)pushViewController:(id)cvc selfController:(id)avc{
    _avc = avc;
    [self PushViewController:cvc animated:YES];
}
- (void)viewWillAppear:(BOOL)animated{
    [super viewWillAppear:animated];
    if (_avc) {
        [AppWindow addSubview:_avc.view];
    }
}

#pragma mark - 协议方法
- (void)hiddenKeyBoard{
    [self keyboardHidden];
}
- (void)keyboardHidden{
    [_purchaseView.otherPriceFiled resignFirstResponder];
    [_purchaseView.remarkTextView resignFirstResponder];
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
