//
//  PurchaseDetailViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/23.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "PurchaseDetailViewController.h"
#import "ProductViewController.h"

#define BottomHeight 50
#define LeftMargin 15
#define LeftWidth 100
#define LeftHeight 30
#define TopMargin 15

typedef enum : NSUInteger {
    CancleTag = 3500,
    RejectTag,
    PassTag,
    SureTag
    
} BtnTag;

@interface PurchaseDetailViewController ()
{
    UIScrollView *_scrollView;
    UIView *_purchaseView;
    UIView *_bottomView;
    ProductViewController *_pvc;
    NSArray *_leftArr;
    UIButton *_endBtn;
    UIButton *_rejectBtn;
}
@property (nonatomic,strong)UILabel *billNumberLabel;
@property (nonatomic,strong)UILabel *noticeNumberLabel;
@property (nonatomic,strong)UILabel *createOperNameLabel;
@property (nonatomic,strong)UILabel *checkNameLabel;
@property (nonatomic,strong)UILabel *stateLabel;
@property (nonatomic,strong)UILabel *lastModifyNameLabel;

@property (nonatomic,strong)UILabel *typeLabel;
@property (nonatomic,strong)UILabel *vendorNameLabel;
@property (nonatomic,strong)UILabel *vendorIsSureLabel;
@property (nonatomic,strong)UILabel *warehouseLabel;
@property (nonatomic,strong)UILabel *otherPriceLabel;



@property (nonatomic,strong)UILabel *totalPriceLabel;
@property (nonatomic,strong)UILabel *noteLabel;

@end

@implementation PurchaseDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self bulidLayout];
}



#pragma mark - 视图初始化
- (void)bulidLayout{
    _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, ScreenSize.height - 64 - BottomHeight)];
    _scrollView.showsHorizontalScrollIndicator  = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    _scrollView.backgroundColor = HexColor(@"f8f8f8");
    [self.view addSubview:_scrollView];
    [self createBtn];
    [self createPurchaseView];
    [self createBottomView];
    if ([self.bill.state isEqualToString:@"finished"]) {
        _endBtn.hidden = YES;
        _rejectBtn.hidden = YES;
        CGRect scrollViewFrame = _scrollView.frame;
        scrollViewFrame.size.height = ScreenSize.height - 64;
        _scrollView.frame = scrollViewFrame;
    }
    [self fetchtPurchaseDetail];
}

- (void)createBtn{
    
    
    _endBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, ScreenSize.height  - 64 - BottomHeight +5, ScreenSize.width - LeftMargin*2, 40) target:self sel:@selector(btnClick:) tag:0 image:nil title:@"作废" titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:HexColor(@"f69100")];
    [self.view addSubview:_endBtn];
    if (self.indexPerson == 0) {
        _endBtn.tag = CancleTag;
        [_endBtn setTitle:@"作废" forState:UIControlStateNormal];

    }else if(self.indexPerson == 1){
        _rejectBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, ScreenSize.height  - 64 - BottomHeight +5, (ScreenSize.width - LeftMargin*3)/2, 40) target:self sel:@selector(btnClick:) tag:RejectTag image:nil title:@"拒绝" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:HexColor(@"50bd62")];
        [self.view addSubview:_rejectBtn];
        
        _endBtn.frame = CGRectMake(CGRectGetMaxX(_rejectBtn.frame)+ LeftMargin, ScreenSize.height  - 64 - BottomHeight +5, (ScreenSize.width - LeftMargin*3)/2, 40);
        [_endBtn setTitle:@"审核通过" forState:UIControlStateNormal];
        _endBtn.tag = PassTag;
        
    }else{
        _endBtn.tag = SureTag;
        [_endBtn setTitle:@"确认" forState:UIControlStateNormal];
    }

}

- (void)createBottomView{
    _bottomView= [[UIView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_purchaseView.frame) + TopMargin, ScreenSize.width, 200)];
    _bottomView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_bottomView];
    
    _pvc = [[ProductViewController alloc]init];
    [self addChildViewController:_pvc];
    
    _pvc.viewFrame = _bottomView.bounds;
    _pvc.isHiddenEdit = YES;
    [_bottomView addSubview:_pvc.view];
}

- (void)createPurchaseView{
    if (self.indexPerson == 0) {
        _leftArr = @[@"单号:",@"采购通知单:",@"创建人:",@"最后修改人:",@"状态:",@"类型:",@"供应商:",@"供应商确认:",@"收货仓库:",@"其他费用:",@"总金额:",@"备注:"];
    }else if (self.indexPerson == 1) {
        _leftArr = @[@"单号:",@"采购通知单:",@"创建人:",@"审核人:",@"状态:",@"类型:",@"供应商:",@"供应商确认:",@"收货仓库:",@"其他费用:",@"总金额:",@"备注:"];
    }else{
        _leftArr = @[@"单号:",@"采购通知单:",@"创建人:",@"审核人:",@"状态:",@"供应商:",@"其他费用:",@"总金额:",@"备注:"];
    }
    _purchaseView= [[UIView alloc]initWithFrame:CGRectMake(0, TopMargin, ScreenSize.width, LeftHeight*_leftArr.count +LeftMargin)];
    _purchaseView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_purchaseView];
    
    for (NSInteger i = 0 ; i < _leftArr.count; i++) {
        UILabel *leftLabel = [[UILabel alloc]initWithFrame:CGRectMake(LeftMargin, 10 + LeftHeight *i, LeftWidth, LeftHeight)];
        leftLabel.font = FontSize(17);
        leftLabel.text = _leftArr[i];
        leftLabel.textColor = HexColor(@"888888");
        [_purchaseView addSubview:leftLabel];
        
        UILabel *rightLabel = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(leftLabel.frame), 10 + LeftHeight *i, _purchaseView.frame.size.width - LeftMargin - LeftWidth, LeftHeight)];
        rightLabel.font = FontSize(17);
        rightLabel.textColor = HexColor(@"888888");
        
        if (i == 0) {
            self.billNumberLabel = rightLabel;
        }else if (i == 1) {
            self.noticeNumberLabel = rightLabel;
        }else if(i == 2){
            self.createOperNameLabel = rightLabel;
        }else if(i == _leftArr.count - 3){
            self.otherPriceLabel = rightLabel;
        }else if(i == _leftArr.count - 2){
            self.totalPriceLabel = rightLabel;
        }else if(i == _leftArr.count - 1){
            rightLabel.numberOfLines = 0;
            self.noteLabel = rightLabel;
        }
        if (self.indexPerson == 0 || self.indexPerson == 1) {
            if (self.indexPerson == 0) {
                if (i == 3) {
                    self.lastModifyNameLabel = rightLabel;
                }
            }else{
                if (i == 3) {
                    self.checkNameLabel = rightLabel;
                }
            }
            if(i == 4){
                self.stateLabel = rightLabel;
            }else if(i == 5){
                self.typeLabel = rightLabel;
            }else if(i == 6){
                self.vendorNameLabel = rightLabel;
            }else if(i == 7){
                self.vendorIsSureLabel = rightLabel;
            }else if(i == 8){
                self.warehouseLabel = rightLabel;
            }
        }else{
            if(i == 3){
                self.checkNameLabel = rightLabel;
            }else if(i == 4){
                self.stateLabel = rightLabel;
            }else if(i == 5){
                self.vendorNameLabel = rightLabel;
            }
        }
        [_purchaseView addSubview:rightLabel];
    }
}

- (void)fetchtPurchaseDetail{
    self.billNumberLabel.text = [IBTCommon checkString:self.bill.billNumber];
    if ([self.bill.state isEqualToString:@"initial"]) {
        self.stateLabel.textColor = [UIColor redColor];
        self.stateLabel.text = @"未提交";
    }else if ([self.bill.state isEqualToString:@"submitted"]) {
        self.stateLabel.textColor = [UIColor greenColor];
        self.stateLabel.text = @"已提交";
    }else if ([self.bill.state isEqualToString:@"rejected"]) {
        self.stateLabel.textColor = [UIColor grayColor];
        self.stateLabel.text = @"已拒绝";
    }else if ([self.bill.state isEqualToString:@"approved"]) {
        self.stateLabel.textColor = [UIColor grayColor];
        self.stateLabel.text = @"已审批";
    }else if ([self.bill.state isEqualToString:@"shipping"]) {
        self.stateLabel.textColor = [UIColor grayColor];
        self.stateLabel.text = @"发运中";
    }else if ([self.bill.state isEqualToString:@"finished"]) {
        self.stateLabel.textColor = [UIColor blackColor];
        self.stateLabel.text = @"已完成";
    }
    self.noticeNumberLabel.text = [IBTCommon checkString:self.bill.noticeNumber];
    self.createOperNameLabel.text = [IBTCommon checkString:self.bill.create_operName];
    self.checkNameLabel.text = [IBTCommon checkString:self.bill.vendor_name];
    self.vendorNameLabel.text = [IBTCommon checkString:self.bill.vendor_name];
    self.totalPriceLabel.text = [IBTCommon checkString:self.bill.total];
    self.noteLabel.text = [IBTCommon checkString:self.bill.remark];
    self.lastModifyNameLabel.text = @"最后修改人";
    self.typeLabel.text = @"类型";
    self.vendorIsSureLabel.text = @"是否确认";
    self.warehouseLabel.text = @"仓库";
    self.otherPriceLabel.text = @"其他费用";
    
    
    [self setNoteHeight];
}

- (void)setNoteHeight
{
    CGFloat height =  [self.noteLabel calculateHeight];
    
    CGRect noteFrame = self.noteLabel.frame;
    noteFrame.size.height = height;
    self.noteLabel.frame = noteFrame;
    
    CGFloat totalHeight = height + LeftHeight*_leftArr.count;
    CGRect purchaseFrame = _purchaseView.frame;
    purchaseFrame.size.height = totalHeight;
    _purchaseView.frame = purchaseFrame;
    
    
    CGRect bottomFrame = _bottomView.frame;
    bottomFrame.origin.y = CGRectGetMaxY(_purchaseView.frame) + TopMargin;
    _bottomView.frame = bottomFrame;
    
    _scrollView.contentSize = CGSizeMake(ScreenSize.width, totalHeight + CGRectGetHeight(_bottomView.frame) + TopMargin*2);
}





- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
