//
//  ProductCell.m
//  XFFruit
//
//  Created by n22 on 15/8/21.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ProductCell.h"
#define LeftMargin 13
#define TableHeight 44
#define SmallSize 10
#define SmallWidth 20
#define ContentColor @"444444"
#define ContentSize 16
#define SpaceMargin 1
#define LeftWidth 45
#define RightWidth 30

#define ShowColor @"bbbbbb"
#define ShowSize 13
#define ShowWidth 150
#define ShowHeight 20
@implementation ProductCell



- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    CGFloat headWidth = (ScreenSize.width - LeftWidth*2 - SpaceMargin* (3 -1))/3;
    
    self.smallImageView = [[UIImageView alloc]initWithFrame:CGRectMake(LeftMargin, (TableHeight - SmallSize)/2 , SmallSize, SmallSize)];
    self.smallImageView.image = [UIImage imageNamed:@"arrowright"];
    self.smallImageView.contentMode = UIViewContentModeScaleAspectFit;
    
    self.seqLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.smallImageView.frame), 0, SmallWidth, TableHeight))];
    self.seqLabel.textColor = HexColor(ContentColor);
    self.seqLabel.text = @"13";
    self.seqLabel.font = FontSize(ContentSize);
    
    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftWidth, 0, headWidth, TableHeight))];
    self.titleLabel.textAlignment = NSTextAlignmentLeft;
    self.titleLabel.textColor = HexColor(ContentColor);
    self.titleLabel.text = @"苹果桃子";
    self.titleLabel.font = FontSize(ContentSize);
    
    self.priceLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.titleLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.priceLabel.textAlignment = NSTextAlignmentLeft;
    self.priceLabel.textColor = HexColor(ContentColor);
    self.priceLabel.text = @"80";
    self.priceLabel.font = FontSize(ContentSize);
    
//    self.standardLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.priceLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
//    self.standardLabel.textAlignment = NSTextAlignmentLeft;
//    self.standardLabel.text = @"20*20";
//    self.standardLabel.backgroundColor = [UIColor redColor];
//    self.standardLabel.textColor = HexColor(ContentColor);
//    self.standardLabel.font = FontSize(ContentSize);
    
    self.countLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.priceLabel.frame) + SpaceMargin, 0, headWidth, TableHeight))];
    self.countLabel.textAlignment = NSTextAlignmentLeft;
    self.countLabel.text = @"200";
    self.countLabel.textColor = HexColor(ContentColor);
    self.countLabel.font = FontSize(ContentSize);

    
    self.showView = [[UIView alloc]initWithFrame:CGRectMake(0, TableHeight, ScreenSize.width, 0)];
//    self.showView.hidden = YES;
    self.showView.clipsToBounds = YES;
    
    self.showTitleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.seqLabel.frame), 0, ShowWidth, ShowHeight))];
    self.showTitleLabel.textAlignment = NSTextAlignmentLeft;
    self.showTitleLabel.textColor = HexColor(ShowColor);
    self.showTitleLabel.text = @"原料：苹果桃子";
    self.showTitleLabel.font = FontSize(ShowSize);
    
    self.showBaseCountLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.showTitleLabel.frame), 0, ShowWidth, ShowHeight))];
    self.showBaseCountLabel.textAlignment = NSTextAlignmentLeft;
    self.showBaseCountLabel.textColor = HexColor(ShowColor);
    self.showBaseCountLabel.text = @"基础数量：10000";
    self.showBaseCountLabel.font = FontSize(ShowSize);
    
    self.showDateLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showTitleLabel.frame), CGRectGetMaxY(self.showTitleLabel.frame), ShowWidth, ShowHeight))];
    self.showDateLabel.textAlignment = NSTextAlignmentLeft;
    self.showDateLabel.textColor = HexColor(ShowColor);
    self.showDateLabel.text = @"入库时间：2015-02-04";
    self.showDateLabel.font = FontSize(ShowSize);
    
    self.basePriceLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showBaseCountLabel.frame), CGRectGetMaxY(self.showTitleLabel.frame), ShowWidth, ShowHeight))];
    self.basePriceLabel.textAlignment = NSTextAlignmentLeft;
    self.basePriceLabel.textColor = HexColor(ShowColor);
    self.basePriceLabel.text = @"基础单价：11元";
    self.basePriceLabel.font = FontSize(ShowSize);
    
    self.totalPriceLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showTitleLabel.frame), CGRectGetMaxY(self.showDateLabel.frame), ShowWidth, ShowHeight))];
    self.totalPriceLabel.textAlignment = NSTextAlignmentLeft;
    self.totalPriceLabel.textColor = HexColor(ShowColor);
    self.totalPriceLabel.text = @"总金额：1000";
    self.totalPriceLabel.font = FontSize(ShowSize);
    
    self.placeLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showBaseCountLabel.frame), CGRectGetMaxY(self.showDateLabel.frame), ShowWidth, ShowHeight))];
    self.placeLabel.textAlignment = NSTextAlignmentLeft;
    self.placeLabel.textColor = HexColor(ShowColor);
    self.placeLabel.text = @"产地：河南省";
    self.placeLabel.font = FontSize(ShowSize);
    
    self.qualityLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showTitleLabel.frame), CGRectGetMaxY(self.totalPriceLabel.frame), ShowWidth, ShowHeight))];
    self.qualityLabel.textAlignment = NSTextAlignmentLeft;
    self.qualityLabel.textColor = HexColor(ShowColor);
    self.qualityLabel.text = @"质量：1000";
    self.qualityLabel.font = FontSize(ShowSize);
    
    self.remarkLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.showTitleLabel.frame), CGRectGetMaxY(self.qualityLabel.frame), ShowWidth, ShowHeight))];
    self.remarkLabel.textAlignment = NSTextAlignmentLeft;
    self.remarkLabel.textColor = HexColor(ShowColor);
    self.remarkLabel.text = @"描述：河南省";
    self.remarkLabel.font = FontSize(ShowSize);
    
    
    
    
    self.editBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [self.editBtn setImage:[UIImage imageNamed:@"edit"] forState:UIControlStateNormal];
    self.editBtn.frame = CGRectMake(ScreenSize.width - LeftWidth, 0, LeftWidth , TableHeight);
    self.editBtn.contentMode = UIViewContentModeScaleAspectFit;

    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin,TableHeight-1, ScreenSize.width  - LeftMargin * 2, 1))];;
    self.lineLabel.backgroundColor = HexColor(@"e5e5e5");
    
    [self.contentView addSubview:self.smallImageView];
    [self.contentView addSubview:self.seqLabel];
    [self.contentView addSubview:self.titleLabel];
    [self.contentView addSubview:self.priceLabel];
//    [self.contentView addSubview:self.standardLabel];
    [self.contentView addSubview:self.countLabel];
    

    [self.contentView addSubview:self.editBtn];
    [self.contentView addSubview:self.showView];
    
    [self.showView addSubview:self.showTitleLabel];
    [self.showView addSubview:self.showBaseCountLabel];
    [self.showView addSubview:self.showDateLabel];
    [self.showView addSubview:self.basePriceLabel];
    [self.showView addSubview:self.totalPriceLabel];
    [self.showView addSubview:self.placeLabel];
    [self.showView addSubview:self.qualityLabel];
    [self.showView addSubview:self.remarkLabel];
    [self.contentView addSubview:self.lineLabel];
    
    
}



- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
