//
//  UIImage+Helper.h
//  CXA
//
//  Created by Xummer on 14-3-3.
//  Copyright (c) 2014年 Xummer. All rights reserved.
//

#import <UIKit/UIKit.h>

@interface UIImage (Helper)

+ (UIImage *)getThumbnailImage:(UIImage *)image withMaxLen:(CGFloat)maxLen;
- (UIImage *)thumbnailWithMaxLen:(CGFloat)maxLen;

- (UIImage *)imageWithTintColor:(UIColor *)tintColor;

- (UIImage *)imageWithGradientTintColor:(UIColor *)tintColor;

- (UIImage *)imageWithTintColor:(UIColor *)tintColor blendMode:(CGBlendMode)blendMode;

@end

@interface UIImage (Color)
+ (UIImage *)imageWithColor:(UIColor *)color;
+ (UIImage *)imageWithColor:(UIColor *)color andSize:(CGSize)size;
+ (UIImage *)imageWithColor:(UIColor *)color andRect:(CGRect)rect;
- (UIImage *)greyScaleImage;
@end
