//
//  IBTCommon.h
//  AceMTer
//
//  Created by Xummer on 2/27/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTObject.h"

@interface IBTFileData : IBTObject
@property (strong, nonatomic) NSString *filePath;
@property (strong, nonatomic) NSString *fileName;
@property (strong, nonatomic) NSData *fileData;
@end

@interface IBTCommon : IBTObject

+ (NSString *)localizableString:(NSString *)text;
+ (UIImage *)localizableImage:(NSString *)name;

+ (UIImage *)appIcon;

+ (void)runOnMainThreadWithoutDeadlocking:(void (^)(void))block;

+ (BOOL)isLegalString:(NSString *)string WithRegex:(NSString *)regexStr;

// File Path
+ (NSString *)archivePathForCurrentUser;

+ (NSString *)archivePathForTmpImages;

+ (IBTFileData *)saveImageToLocal:(UIImage *)imageToSave;

+ (NSDate *)convertToDateFrom:(NSString *)dateString;
+ (NSString *)stringFromDate:(NSDate*)aDate;
+ (NSString*)dictionaryToJson:(id)dic;
+ (NSString *)checkString:(NSString *)str;
+ (BOOL)checkStringIsNilOrSpance: (NSString *)str;
+ (NSMutableAttributedString *)setTextViewFontOfString:(NSString *)string paragraphStyle:(NSInteger)lineHeight fontSize:(float)size color:(UIColor *)color;
+ (NSString *)trimmingCharacters:(NSString *)str;
+ (int)compareDate:(NSString*)oneDate withDate:(NSString*)twoDate;
@end
