//
//  TransportPurchaseCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/6.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "TransportPurchaseCell.h"
#import "PurchaseBillProduct.h"
#import "HeaderCell.h"
@implementation TransportPurchaseCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{

    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0,0, ScreenSize.width, 1))];;
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;

    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0, 0, ScreenSize.width, 44))];
    self.titleLabel.textAlignment = NSTextAlignmentCenter;
    self.titleLabel.textColor = GXF_NAVIGAYION_COLOR;
    self.titleLabel.text = @"苹果桃子";
    self.titleLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.secondLabel = [[UILabel alloc]initWithFrame:(CGRectMake(0,44-1, ScreenSize.width, 1))];;
    self.secondLabel.backgroundColor = GXF_LINE_COLOR;
    
    [self.contentView addSubview:self.titleLabel];
    [self.contentView addSubview:self.lineLabel];
    [self.contentView addSubview:self.secondLabel];

}
- (void)setBill:(PurchaseBill *)bill{
    self.titleLabel.text = [NSString stringWithFormat:@"[采购单:%@]",bill.billNumber];
    self.secondArr = [NSMutableArray array];
    self.selectArr = [NSMutableArray array];
    [self.secondArr addObjectsFromArray:bill.products];
//    for (NSDictionary *billDict in bill.products) {
//        PurchaseBillProduct *billProcuct = [PurchaseBillProduct new];
//        [billProcuct setValuesForKeysWithDictionary:billDict];
//        [self.secondArr addObject:billProcuct];
//    }

    self.secondTable = [[UITableView alloc]initWithFrame:(CGRectMake(0, 44,ScreenSize.width, 200-44)) style:(UITableViewStylePlain)];

    self.secondTable.delegate = self;
    self.secondTable.dataSource = self;
    self.secondTable.bounces = NO;
    self.secondTable.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.contentView addSubview:self.secondTable];
    NSArray *arr = @[@"商品",@"单价",@"包装数量"];
    
    HeaderCell *headCell = [[HeaderCell alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 38) withArr:arr];
    self.secondTable.tableHeaderView = headCell;
    //重要
    [self.secondTable reloadData];

}

-(NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.secondArr.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *cellID = @"ProductBillCell";
    ProductBillCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[ProductBillCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        cell.editBtn.hidden = YES;
    }
    PurchaseBillProduct * billProduct = self.secondArr[indexPath.row];
    [cell setBillProduct:billProduct row:indexPath.row];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
    
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
      ProductBillCell *cell = (ProductBillCell *)[tableView cellForRowAtIndexPath:indexPath];
      PurchaseBillProduct * billProduct = self.secondArr[indexPath.row];
        if (![self isHaveIndexPath:indexPath]) {
            cell.editBtn.hidden = NO;
            [self.selectArr addObject:indexPath];
            [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_getSelectPurchaseProduct object:nil userInfo:@{@"selectArr":billProduct,@"state":@"add"}];
        }else{
            [self.selectArr removeObject:indexPath];
            cell.editBtn.hidden = YES;
            [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_getSelectPurchaseProduct object:nil userInfo:@{@"selectArr":billProduct,@"state":@"remove"}];
        }
    
    ;
}
- (BOOL)isHaveIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in self.selectArr) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}
- (void)awakeFromNib {
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
