//
//  ChooseProductViewController.m
//  XFFruit
//
//  Created by n22 on 15/8/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ChooseProductViewController.h"
#define TopMargin 50
#define TableHeight 50
@interface ChooseProductViewController ()
{
}
@end

@implementation ChooseProductViewController
- (void)viewDidLoad {
    [super viewDidLoad];
    //记录更新时间
     self.tableView.header.lastUpdatedTimeKey = ChooseProductUpdateDate;
     self.title = @"选择商品";
    [self fetchDataList:@"" tableStr:GXF_BASECLASS_PRODUCT];
}
- (void)getBaseDataFromServer{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        [strongSelf endRefreshing];
        [strongSelf fetchDataList:@"" tableStr:GXF_BASECLASS_PRODUCT];
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getProductWithPage_number:0 page_size:100 success:succ failure:fail];
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskCell";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth:ScreenSize.width totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.Commitbtn.hidden = YES;
    }
    if (self.isMoreChose) {
        if ([self isHaveIndexPath:indexPath]) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }else{
        if (self.currentIndexPath) {
            if (indexPath.row == self.currentIndexPath.row) {
                cell.Commitbtn.hidden = NO;
            }else{
                cell.Commitbtn.hidden = YES;
            }
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }
    if (self.dataArr.count > 0) {
        if (indexPath.row == 0) {
            NSString *dateStr = [self.dataArr[indexPath.row] httpParameterString];
            cell.titleLabel.textColor = GXF_CONTENT_COLOR;
            [cell setTitleStr:[NSString stringWithFormat:@"上次更新时间:%@",dateStr]];
        }else{
            Product *product = self.dataArr[indexPath.row];
            cell.titleLabel.textColor = GXF_LEFTSIX_COLOR;
            NSString *proStr = [NSString stringWithFormat:@"%@[%@]",product.name,product.code];
            [cell setTitleStr:proStr];
        }
    }
    return cell;
}
- (void)boxValueChanged:(NSNotification *)fication{
    NSString *tilkeStr = [IBTCommon trimmingCharacters:self.selectTextFiled.text];
    [self fetchDataList:tilkeStr tableStr:GXF_BASECLASS_PRODUCT];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

@end
