//
//  CalculateHelper.h
//  XFFruit
//
//  Created by Z on 16/7/14.
//  Copyright © 2016年 Xummer. All rights reserved.
//

#import <Foundation/Foundation.h>
typedef NS_ENUM(NSInteger, CalculateType) {
    CalculateTypeAdd = 0, //加
    CalculateTypeSub,  //减
    CalculateTypeMul,  //乘
    CalculateTypeDiv   //除
};
@interface CalculateHelper : NSObject

/*
 NSRoundPlain,   // Round up on a tie ／／貌似取整
 NSRoundDown,    // Always down == truncate  ／／只舍不入
 NSRoundUp,      // Always up    ／／ 只入不舍
 NSRoundBankers  // on a tie round so last digit is even  貌似四舍五入
 */
/**
 *  计算
 *
 *  @param num1         第一个数字
 *  @param num2         第二个数字
 *  @param type         计算类型（加减乘除）
 *  @param roundingType 四舍五入类型
 *  @param coutLenth    小数点后面保留几位
 *
 *  @return 结算结果
 */
+ (NSDecimalNumber *)calculateNum1:(id)num1 num2:(id)num2 type:(CalculateType)type roundingType:(NSRoundingMode)roundingType cutLenth:(NSInteger)coutLenth;
+ (NSString *)getMoneyStringFrom:(id)num Lenth:(NSInteger)cutLenth;
+ (NSString *)getMoneyStringFrom:(id)num;
+ (NSDecimalNumber *)changeType:(id)num1;
@end
