//
//  CalculateHelper.m
//  XFFruit
//
//  Created by Z on 16/7/14.
//  Copyright © 2016年 Xummer. All rights reserved.
//

#import "CalculateHelper.h"

@implementation CalculateHelper


+ (NSDecimalNumber *)calculateNum1:(id)num1 num2:(id)num2 type:(CalculateType)type roundingType:(NSRoundingMode)roundingType cutLenth:(NSInteger)coutLenth {
    NSDecimalNumberHandler *roundUp = [NSDecimalNumberHandler
                                       
                                       decimalNumberHandlerWithRoundingMode:roundingType
                                       
                                       scale:coutLenth
                                       
                                       raiseOnExactness:NO
                                       
                                       raiseOnOverflow:NO
                                       
                                       raiseOnUnderflow:NO
                                       
                                       raiseOnDivideByZero:YES];
    NSDecimalNumber *decimalNum1 = [self changeType:num1];
    NSDecimalNumber *decimalNum2 = [self changeType:num2];
    
    
    NSDecimalNumber *decimalResult;
    NSString *result;
    switch (type) {
        case CalculateTypeAdd: {
            decimalResult = [decimalNum1 decimalNumberByAdding:decimalNum2 withBehavior:roundUp];
            result = [decimalResult stringValue];
            break;
        }
        case CalculateTypeSub: {
            decimalResult = [decimalNum1 decimalNumberBySubtracting:decimalNum2 withBehavior:roundUp];
            result = [decimalResult stringValue];
            break;
        }
        case CalculateTypeMul: {
            decimalResult = [decimalNum1 decimalNumberByMultiplyingBy:decimalNum2 withBehavior:roundUp];
            result = [decimalResult stringValue];
            break;
        }
        case CalculateTypeDiv: {
            decimalResult = [decimalNum1 decimalNumberByDividingBy:decimalNum2 withBehavior:roundUp];
            result = [decimalResult stringValue];
            break;
        }
    }
    
    
    return decimalResult;
}

+ (NSDecimalNumber *)changeType:(id)num1 {
    NSDecimalNumber *decimalNum1;
    if ([num1 isKindOfClass:[NSDecimalNumber class]]) {
        decimalNum1 = num1;
    }else if([num1 isKindOfClass:[NSString class]]){
        decimalNum1 = [NSDecimalNumber decimalNumberWithString:num1];
    }else if ([num1 isKindOfClass:[NSNumber class]]){
        decimalNum1 = [NSDecimalNumber decimalNumberWithDecimal:[num1 decimalValue]];
    }else if(num1 == nil){
        decimalNum1 = [NSDecimalNumber decimalNumberWithString:@"0"];
    }
    return decimalNum1;
}

+ (NSString *)getMoneyStringFrom:(id)num Lenth:(NSInteger)cutLenth {
    NSDecimalNumberHandler *roundUp = [NSDecimalNumberHandler
                                       decimalNumberHandlerWithRoundingMode:NSRoundBankers
                                       scale:cutLenth ? cutLenth : 2
                                       raiseOnExactness:NO
                                       raiseOnOverflow:NO
                                       raiseOnUnderflow:NO
                                       raiseOnDivideByZero:YES];
    NSDecimalNumber *decimal = [self changeType:num];
    NSDecimalNumber *result = [decimal decimalNumberByAdding:[NSDecimalNumber decimalNumberWithString:@"0"] withBehavior:roundUp];
    return [result stringValue];
}

+ (NSString *)getMoneyStringFrom:(id)num{
    NSString *originString = [self getMoneyStringFrom:num Lenth:2];
    NSArray *array = [originString componentsSeparatedByString:@"."];
    NSString *top = array[0];
    NSString *result;
    
    if (array.count == 1) {
        result = [NSString stringWithFormat:@"%@.00",top];
    }else if(array.count == 2){
        NSString *bottom = array[1];
        if (bottom.length == 2) {
            result = originString;
        }
        
        
        NSString *chr;
        for (NSInteger i = bottom.length; i < 2; i++) {
            chr =[bottom substringWithRange:NSMakeRange(i, 1)];
            if ([chr isEqualToString:@"0"]) {
                result = [top stringByAppendingString:chr];
            }
        }
    }
    return result;
}

@end
