//
//  SurveyResultCell.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "SurveyResultCell.h"
#import "UIButton+WebCache.h"

#define TopMargin 10
#define TitleHeight 20
#define LeftWidth 100
#define TableHeight 150
#define ContentSize 14
@implementation SurveyResultCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    self.imageBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    self.imageBtn.frame = CGRectMake(TopMargin *2 , TopMargin, LeftWidth, TableHeight - TopMargin*2);
    
    self.dateLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMaxX(self.imageBtn.frame) + TopMargin, TopMargin, ScreenSize.width - TopMargin*2 - LeftWidth, TitleHeight))];
    self.dateLabel.textColor = GXF_CELL_COLOR;
    self.dateLabel.font = GXF_FOURTEENTH_SIZE;
    
    self.userNameLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.dateLabel.frame), CGRectGetMaxY(self.dateLabel.frame), CGRectGetWidth(self.dateLabel.frame), 30))];
    self.userNameLabel.textColor = GXF_CONTENT_COLOR;
    self.userNameLabel.font = GXF_SIXTEENTEH_SIZE;
    
    self.placeLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.userNameLabel.frame), CGRectGetMaxY(self.userNameLabel.frame), CGRectGetWidth(self.userNameLabel.frame), TitleHeight))];
    self.placeLabel.textColor = GXF_CELL_COLOR;
    self.placeLabel.font = GXF_FOURTEENTH_SIZE;
    
    self.priceLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.userNameLabel.frame), CGRectGetMaxY(self.placeLabel.frame), CGRectGetWidth(self.userNameLabel.frame), TitleHeight))];
    self.priceLabel.textColor = GXF_CELL_COLOR;
    self.priceLabel.font = GXF_FOURTEENTH_SIZE;
    
    
    self.capacityLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.userNameLabel.frame), CGRectGetMaxY(self.priceLabel.frame), CGRectGetWidth(self.userNameLabel.frame), TitleHeight))];
    self.capacityLabel.textColor = GXF_CELL_COLOR;
    self.capacityLabel.font = GXF_FOURTEENTH_SIZE;
    
    self.qualityLabel = [[UILabel alloc]initWithFrame:(CGRectMake(CGRectGetMinX(self.userNameLabel.frame), CGRectGetMaxY(self.capacityLabel.frame), CGRectGetWidth(self.userNameLabel.frame), TitleHeight))];
    self.qualityLabel.textColor = GXF_CELL_COLOR;
    self.qualityLabel.font = GXF_FOURTEENTH_SIZE;
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(TopMargin,TableHeight-1, ScreenSize.width  - TopMargin * 2, 1))];;
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    
    [self.contentView addSubview:self.imageBtn];
    [self.contentView addSubview:self.dateLabel];
    [self.contentView addSubview:self.userNameLabel];
    [self.contentView addSubview:self.placeLabel];
    [self.contentView addSubview:self.priceLabel];
    [self.contentView addSubview:self.capacityLabel];
    [self.contentView addSubview:self.qualityLabel];
    [self.contentView addSubview:self.lineLabel];
    
}

- (void)setSurveyResult:(SurveyResult *)surveyResult{
#ifdef Demonstrate
    [self.imageBtn setBackgroundImage:[UIImage imageNamed:@"no_image_default_demo"] forState:UIControlStateNormal];
#else
    [self.imageBtn setBackgroundImage:[UIImage imageNamed:@"no_image_default"] forState:UIControlStateNormal];
#endif
    [self.imageBtn sd_setImageWithURL:[surveyResult.attachmnets count] > 0 ? surveyResult.attachmnets[0] : nil forState:UIControlStateNormal];
    self.imageBtn.imageView.contentMode = UIViewContentModeScaleAspectFill;
    self.dateLabel.text = [NSString stringWithFormat:@"%@",surveyResult.feedbackTime];
    self.userNameLabel.text = [NSString stringWithFormat:@"反馈人：%@",surveyResult.userName];
    self.placeLabel.text = [NSString stringWithFormat:@"产地：%@",surveyResult.place];
     NSMutableAttributedString *attributeStr1 = [IBTCommon setTextViewFontOfString:@"价格：" paragraphStyle:0 fontSize:ContentSize color:GXF_CELL_COLOR];
    NSString *str = [NSString stringWithFormat:@"%@",surveyResult.price];
    [attributeStr1 appendAttributedString:[IBTCommon setTextViewFontOfString:str paragraphStyle:0 fontSize:ContentSize color:[UIColor redColor]]];
    self.priceLabel.attributedText = attributeStr1;
    self.capacityLabel.text = [NSString stringWithFormat:@"市场容量：%@",surveyResult.capacity];
    self.qualityLabel.text  = [NSString stringWithFormat:@"质量情况：%@",surveyResult.quality];
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
