//
//  ResultDetailViewController.m
//  XFFruit
//
//  Created by n22 on 15/8/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ResultDetailViewController.h"
#import "SurveyResult.h"
#import "SurveyResultCell.h"
#import "ResultView.h"

#define TableHeight 150
#define BeginTag 6000
@interface ResultDetailViewController ()<UITableViewDataSource,UITableViewDelegate,ResultViewDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
    ResultView *_resultView;
}
@end

@implementation ResultDetailViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"行情反馈列表";
    [self initData];
    [self createTableView];
}

- (void)initData{
    _dataArr = [NSMutableArray array];
    
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        [strongSelf fetchtSurveyResultList:data];
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    
    [[ICRHTTPController sharedController] getResultsWithUuid:self.surveyUuid success:succ failure:fail];
}

- (void)fetchtSurveyResultList:(id)data{
    if (data) {
        NSInteger success = [data[@"success"] integerValue];
        NSString *message  = data[@"message"] ;
        if (success == 1) {
            if (_dataArr.count > 0) {
                [_dataArr removeAllObjects];
            }
            NSArray *dataArr = data[ @"data" ];
            for (NSDictionary *surveyDict in dataArr) {
                NSDictionary *resultDict = surveyDict[@"result"];
                SurveyResult *surveyResult = [[SurveyResult alloc]init];
                [surveyResult setValuesForKeysWithDictionary:resultDict];
                surveyResult.attachmnets = surveyDict[@"attachments"];
                
                NSMutableArray *imageArr = [NSMutableArray array];
                for (NSString *str in surveyResult.attachmnets) {
                    NSRange range = [HTTP_REST_API_BASE_URL rangeOfString:@"cruiser"];
                    NSString *str1 = [HTTP_REST_API_BASE_URL substringToIndex:range.location];
                    NSString *url = [NSString stringWithFormat:@"%@%@", str1, str];
                    [imageArr addObject:url];
                }
                surveyResult.attachmnets = imageArr;
                
                [_dataArr addObject:surveyResult];
//                [self getDownLoadAttachement:surveyResult];
            }
            [_tableView reloadData];
        }else{
            [IBTLoadingView showTips:message];
        }
    }else{
        [IBTLoadingView showTips:@"      无记录      "];
    }
}
//- (void)getDownLoadAttachement:(SurveyResult *)surveyResult{
//    NSArray *att = surveyResult.attachmnets;
//    NSString *str = @"";
//    if (att.count > 0) {
//        str = att[0];
//    }
//    __weak typeof(self)weakSelf = self;
//    void(^succ)(id) = ^(id data) {
//        __strong __typeof(weakSelf)strongSelf = weakSelf;
//        if (data) {
//            NSLog(@"%@",data);
//        }
//    };
//    void(^fail)(id) = ^(id data) {
//        [IBTLoadingView showTips:data];
//    };
//    [[ICRHTTPController sharedController] downLoadAttachmentWithUuid:str  success:succ failure:fail];
//}

- (void)createTableView{
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, 0,ScreenSize.width, ScreenSize.height - 64)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.delegate = self;
    _tableView.dataSource = self;
    [self.view addSubview:_tableView];
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"SurveyResultCell";
    SurveyResultCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyResultCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if (_dataArr.count > 0) {
        SurveyResult *survey = _dataArr[indexPath.row];
        cell.surveyResult = survey;
        cell.tag = indexPath.row + BeginTag;
        cell.imageBtn.tag = indexPath.row;
        [cell.imageBtn addTarget:self action:@selector(imageClick:) forControlEvents:UIControlEventTouchUpInside];
    }
    return cell;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}

- (void)imageClick:(UIButton *)btn {
//    SurveyResult *result = _dataArr[btn.tag - BeginTag];
    //创建详情view
    SurveyResult *surveyResult = _dataArr[btn.tag];
    
    if (surveyResult.attachmnets.count > 0) {
        
        if (_resultView == nil) {
            _resultView = [[ResultView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, ScreenSize.height)];

            _resultView.images = surveyResult.attachmnets;
            _resultView.delegate = self;
            _resultView.backgroundColor = RGBA(0, 0, 0, 0.5);
            [_resultView setScrollView];
            [AppWindow addSubview:_resultView];
        }
    }
    
    
}

#pragma mark - resultView协议方法
- (void)clickBackButton{
    if (_resultView) {
        [_resultView removeFromSuperview];
        _resultView = nil;
    }
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


@end
