//
//  StartTimeView.m
//  XFFurit
//
//  Created by陈俊俊 on 15/8/5.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "StartTimeView.h"
#define  DateViewHeight 246
@interface StartTimeView ()
{
    UIView *_bgView;
    UIDatePicker *_timePicker;
}
@end

@implementation StartTimeView
- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self bulidLayout];
    }
    return self;
}
- (void)bulidLayout{
    _bgView = [[UIView alloc] initWithFrame:CGRectMake(0, self.frame.size.height - DateViewHeight, ScreenSize.width, DateViewHeight)];
    _bgView.backgroundColor        = RGBA(239, 239, 239 ,1);
    [self addSubview:_bgView];
    
    UIButton *okBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(ScreenSize.width - 62, 0, 62, 28) target:self sel:@selector(okClick) tag:0 image:nil title:@"确定" titleColor:[UIColor blackColor] isCorner:NO corner:0 bgColor:RGBA(239, 239, 239 ,1)];
    [_bgView addSubview:okBtn];
    
    UIButton *cancelBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(0, 0, 62, 28) target:self sel:@selector(cancelClick) tag:0 image:nil title:@"取消" titleColor:[UIColor blackColor] isCorner:NO corner:0 bgColor:RGBA(239, 239, 239 ,1)];
    [_bgView addSubview:cancelBtn];
    
    _timePicker= [[UIDatePicker alloc] initWithFrame:CGRectMake(0, 30,ScreenSize.width, DateViewHeight - 30)];
    _timePicker.backgroundColor  = [UIColor whiteColor];
    _timePicker.datePickerMode   = UIDatePickerModeDate;
    _timePicker.locale = [[NSLocale alloc]initWithLocaleIdentifier:@"zh_CN"];
    // 设置最小时间段，防止用户的出现已过去的时间
    _timePicker.minimumDate      = [NSDate date];
    [_bgView addSubview:_timePicker];
}


- (void)okClick{
    [self.delegate okTimeView:_timePicker.date];
}
- (void)cancelClick{
    [self.delegate cancelTimeView];
}
@end
