//
//  ChooseProductViewController.m
//  XFFruit
//
//  Created by n22 on 15/8/7.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ChooseProductViewController.h"
#import "MaskCell.h"
#define TopMargin 50
#define TableHeight 50
@interface ChooseProductViewController ()<UITableViewDataSource,UITableViewDelegate,UITextFieldDelegate>
{
    UITableView *_tableView;
    UITextField *_selectTextFiled;
    NSMutableArray *_dataArr;
    NSMutableArray *_indexArr;
    NSIndexPath *_currentIndexPath;

    
}@end

@implementation ChooseProductViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self initData];
    [self bulidLayout];
}
- (void)initData{
    _dataArr = [NSMutableArray array];
    _indexArr = [NSMutableArray array];
    [_dataArr addObject:@"商品1"];
    [_dataArr addObject:@"商品2"];
    [_dataArr addObject:@"商品3"];
    [_dataArr addObject:@"商品4"];
    [_dataArr addObject:@"商品5"];
    [_dataArr addObject:@"商品6"];
    [_dataArr addObject:@"商品7"];
    [_dataArr addObject:@"商品8"];
    [_dataArr addObject:@"商品9"];
    [_dataArr addObject:@"商品10"];
    [_dataArr addObject:@"商品11"];
    [_dataArr addObject:@"商品12"];
    [_dataArr addObject:@"商品13"];
    [_dataArr addObject:@"商品14"];
    [_dataArr addObject:@"商品15"];
}
- (void)bulidLayout
{
    self.view.backgroundColor = HexColor(@"f8f8f8");
    _selectTextFiled = [[UITextField alloc] initWithFrame:CGRectMake(20,5,ScreenSize.width - 40,TopMargin -10)];
    _selectTextFiled.textAlignment = NSTextAlignmentLeft;
    _selectTextFiled.background = [UIImage imageNamed:@"textFiled"];
    _selectTextFiled.delegate = self;
    _selectTextFiled.font = FontSize(15);
    [self.view addSubview:_selectTextFiled];
    
    UIImageView *leftView = [[UIImageView alloc]initWithFrame:CGRectMake(0, 0, 35, 40)];
    leftView.image = [UIImage imageNamed:@"search"];
    _selectTextFiled.leftView = leftView;
    _selectTextFiled.leftViewMode = UITextFieldViewModeAlways;
    
    UIButton *rightView = [UIButton buttonWithType:UIButtonTypeCustom];
    [rightView setImage:[UIImage imageNamed:@"delete"] forState:UIControlStateNormal];
    rightView.frame = CGRectMake(0, 0, 35, 40);
    [rightView addTarget:self action:@selector(deletePerson) forControlEvents:UIControlEventTouchUpInside];
    _selectTextFiled.rightView = rightView;
    _selectTextFiled.rightViewMode = UITextFieldViewModeAlways;
    
    
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, TopMargin,ScreenSize.width, ScreenSize.height - 64 - TopMargin)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.delegate = self;
    _tableView.dataSource = self;
    [self.view addSubview:_tableView];
    
    
    UIBarButtonItem *rightItem = [[UIBarButtonItem alloc]initWithTitle:@"确定" style:UIBarButtonItemStylePlain target:self action:@selector(sureClick)];
    self.navigationItem.rightBarButtonItem = rightItem;
}

- (void)sureClick{
    self.choseProduct(_selectTextFiled.text);
    [self PopViewControllerAnimated:YES];
}


- (void)deletePerson {
    _selectTextFiled.text = @"";
    [_indexArr removeAllObjects];
    [_tableView reloadData];
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskCell";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth:ScreenSize.width totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.Commitbtn.hidden = YES;
    }
    if (self.isMoreChose) {
        if ([self isHaveIndexPath:indexPath]) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }else{
        if (_currentIndexPath) {
            if (indexPath.row == _currentIndexPath.row) {
                cell.Commitbtn.hidden = NO;
            }else{
                cell.Commitbtn.hidden = YES;
            }
        }
    }
    [cell setTitleStr:_dataArr[indexPath.row]];
    return cell;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if (self.isMoreChose == YES) {
        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        cell.Commitbtn.hidden = NO;
        if (![self isHaveIndexPath:indexPath]) {
            [_indexArr addObject:indexPath];
        }
        
        NSString *personStr = @"";
        for (NSIndexPath *index in _indexArr) {
            personStr = [personStr stringByAppendingFormat:@"%@、",_dataArr[index.row]];
        }
        _selectTextFiled.text = personStr;
    }else{
        MaskCell *currentCell = (MaskCell *)[tableView cellForRowAtIndexPath:_currentIndexPath];
        currentCell.Commitbtn.hidden = YES;
        MaskCell *cell = (MaskCell *)[tableView cellForRowAtIndexPath:indexPath];
        cell.Commitbtn.hidden = NO;
        _currentIndexPath = indexPath;
        
        
        NSString *name = _dataArr[indexPath.row];
        _selectTextFiled.text = name;
    }
}

- (BOOL)isHaveIndexPath:(NSIndexPath *)indexPath{
    for (NSIndexPath *path in _indexArr) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

@end
