//
//  ICRSystemHeaderView.m
//  XFFruit
//
//  Created by Xummer on 15/4/2.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ICRSystemHeaderView.h"

#define COMPANY_ICON_WIDTH          (60.0f)
#define SYS_HEADER_INNER_GAP        (26.0f)
#define SYS_BOTTOM_LABEL_HEIGHT     (24.0f)

@interface ICRSystemHeaderView ()
@property (strong, nonatomic) UIImageView *m_companyIcon;
@property (strong, nonatomic) IBTUILabel *m_companyLabel;
@property (strong, nonatomic) IBTUILabel *m_userLabel;
@property (strong, nonatomic) IBTUILabel *m_codeLabel;
@property (strong, nonatomic) UIImageView *m_seperatorLine;
@end

@implementation ICRSystemHeaderView

#pragma mark - Life Cycle
- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    
    [self initSubViews];
    
    return self;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    
    CGFloat fDx = 36;
    _m_companyIcon.frame = (CGRect){
        .origin.x = fDx,
        .origin.y = SYS_HEADER_INNER_GAP,
        .size.width = COMPANY_ICON_WIDTH,
        .size.height = COMPANY_ICON_WIDTH
    };
    
    fDx = _m_companyIcon.right + 20;
    _m_companyLabel.frame = (CGRect){
        .origin.x = fDx,
        .origin.y = _m_companyIcon.top,
        .size.width = self.width - fDx - 20,
        .size.height = _m_companyIcon.height
    };
    
    fDx = _m_companyIcon.left;
    CGFloat fWidth = self.width*.5f - fDx;
    
    _m_userLabel.frame = (CGRect){
        .origin.x = fDx,
        .origin.y = _m_companyIcon.bottom + SYS_HEADER_INNER_GAP,
        .size.width = fWidth,
        .size.height = SYS_BOTTOM_LABEL_HEIGHT
    };
    
    _m_seperatorLine.frame =  (CGRect){
        .origin.x = _m_userLabel.right,
        .origin.y = _m_userLabel.top,
        .size.width = 1,
        .size.height = _m_userLabel.height
    };
    
    _m_codeLabel.frame = (CGRect){
        .origin.x = _m_seperatorLine.right,
        .origin.y = _m_userLabel.top,
        .size.width = fWidth,
        .size.height = _m_userLabel.height
    };
    
}

#pragma mark - Private Method
- (void)initSubViews {
    UIImageView *bg = [[UIImageView alloc] initWithImage:[UIImage imageWithColor:HexColor(@"7ebf74")]];//[[UIImageView alloc] initWithImage:[UIImage imageNamed:@"SystemImage"]]; //;
    bg.frame = self.bounds;
//    bg.contentMode = UIViewContentModeScaleAspectFill;
    [bg autoresizingWithStrechFullSize];
    [self addSubview:bg];
    
    self.m_companyIcon = [[UIImageView alloc] init];
    _m_companyIcon.layer.cornerRadius = 4.0f;
    _m_companyIcon.layer.borderWidth = 2.0f;
    _m_companyIcon.layer.borderColor = [UIColor colorWithW:205 a:1].CGColor;
    _m_companyIcon.contentMode = UIViewContentModeScaleAspectFill;
    _m_companyIcon.image = [IBTCommon appIcon];
    [self addSubview:_m_companyIcon];
    
    self.m_companyLabel = [[IBTUILabel alloc] init];
    _m_companyLabel.textAlignment = NSTextAlignmentLeft;
    _m_companyLabel.textColor = [UIColor whiteColor];
    _m_companyLabel.font = [UIFont boldSystemFontOfSize:18];
    [self addSubview:_m_companyLabel];
    
    self.m_userLabel = [[self class] BottomLabel];
    [self addSubview:_m_userLabel];
    
    self.m_codeLabel = [[self class] BottomLabel];
    [self addSubview:_m_codeLabel];
    
    self.m_seperatorLine = [[UIImageView alloc] init];
    _m_seperatorLine.image = [UIImage imageWithColor:[UIColor whiteColor]];
    [self addSubview:_m_seperatorLine];
}

+ (IBTUILabel *)BottomLabel {
    IBTUILabel *label = [[IBTUILabel alloc] init];
    label.textAlignment = NSTextAlignmentCenter;
    label.textColor = [UIColor whiteColor];
    label.font = [UIFont systemFontOfSize:16];
    return label;
}

#pragma mark - Public Method
- (void)updateWithCompanyName:(NSString *)nsCompany
                  companyIcon:(id)icon
                         user:(NSString *)nsUserName
                         code:(NSString *)nsCode
{
    if ([icon isKindOfClass:[NSString class]]) {
        UIImage *iconImage = [UIImage imageNamed:icon];
        if (iconImage) {
            self.m_companyIcon.image = iconImage;
        }
    }
    else if ([icon isKindOfClass:[UIImage class]]) {
        self.m_companyIcon.image = icon;
    }
    else if ([icon isKindOfClass:[NSURL class]]) {
        // TODO
    }
    
    self.m_companyLabel.text = nsCompany ?
    [NSString stringWithFormat:@"%@:%@", [IBTCommon localizableString:@"Company"], nsCompany] :
    nil;
    
    self.m_userLabel.text = nsUserName ?
    [NSString stringWithFormat:@"%@:%@", [IBTCommon localizableString:@"User"], nsUserName] :
    nil;
    
    self.m_codeLabel.text = nsCode ?
    [NSString stringWithFormat:@"%@:%@", [IBTCommon localizableString:@"Code"], nsCode] :
    nil;
}


@end

@implementation ICRSystemHeaderView (Configure)

- (void)updateWithUserUtil {
    ICRUserUtil *userUtil = [ICRUserUtil sharedInstance];
    [self updateWithCompanyName:userUtil.orgName
                    companyIcon:nil
                           user:userUtil.displayName
                           code:userUtil.orgCode];
}

@end
