//
//  GXFNoticeCollectionViewCell.m
//  XFFruit
//
//  Created by freecui on 15/8/27.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "GXFFunctionCollectionViewCell.h"

@implementation GXFFunctionCollectionViewCell

- (id)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (!self) {
        return nil;
    }
    _functionImage = [[UIImageView alloc]initWithFrame:CGRectMake((CGRectGetWidth(self.frame) - ICRFUNCTION_IMG_WIDTH)/2, ICRFUNCTION_IMG_TOP_PADDING, ICRFUNCTION_IMG_WIDTH, ICRFUNCTION_IMG_WIDTH)];
    _functionImage.backgroundColor = [UIColor clearColor];
    [self.contentView addSubview:_functionImage];
    
    _functionNameLabel = [[UILabel alloc] init];
    CGSize labelSize = CGSizeMake(CGRectGetWidth(self.frame), ICRFUNCTION_LABEL_HEIGHT);
    labelSize = [_functionNameLabel sizeThatFits:labelSize];
    _functionNameLabel.frame = (CGRect){
        .origin.x = (CGRectGetWidth(self.frame) - labelSize.width)/2,
        .origin.y = CGRectGetMaxY(_functionImage.frame) + ICRFUNCTION_INNER_GAP,
        .size.width = labelSize.width,
        .size.height = ICRFUNCTION_LABEL_HEIGHT
    };
    _functionNameLabel.textColor = [UIColor colorWithRed:0.596f green:0.596f blue:0.596f alpha:1.00f];
    _functionNameLabel.textAlignment = NSTextAlignmentCenter;
    _functionNameLabel.font = [UIFont systemFontOfSize:13];
    [self.contentView addSubview:_functionNameLabel];
    
    self.backgroundColor = [UIColor whiteColor];
    return self;
}
@end
