//
//  GeometryView.m
//  CNTaipingAgent
//
//  Created by chenchen on 15/9/7.
//  Copyright (c) 2015年 Taiping. All rights reserved.
//
//  虚线边框

#import "GeometryView.h"

@implementation GeometryView

- (void)drawRect:(CGRect)rect
{
    CGFloat dashPattern[] = {3.0, 2};
    
    // 获取绘图上下文
    CGContextRef context = UIGraphicsGetCurrentContext();

    // 线宽
    CGContextSetLineWidth(context, 5.0);
    // 画虚线
    CGContextSetLineDash(context, 0.0, dashPattern, 2);
    
    // 设置线条颜色
    CGContextSetStrokeColorWithColor(context, GXF_NAVIGAYION_COLOR.CGColor);
    
    // 设置填充颜色
    CGContextSetFillColorWithColor(context, [[UIColor whiteColor] CGColor]);
    
    // 填充一个矩形
    CGContextFillRect(context, rect);
    
    // 绘制矩形边框
    CGContextStrokeRect(context, rect);
}

@end
