//
//  PassengerViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/11/8.
//  Copyright © 2015年 Xummer. All rights reserved.
//

#import "PassengerViewController.h"
#import "RPassgerView.h"
#import "PasengerCell.h"
#import "PassengerHeaderCell.h"
#import "ReportDetailViewController.h"
#define LeftWidth   50

static NSString *passengerHeaderIdentify = @"PassengerHeaderIdentify";


@interface PassengerViewController ()<UITableViewDataSource,UITableViewDelegate>
@property (nonatomic,strong)RPassgerView *rpassgerView;

@end

@implementation PassengerViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self bulidLayout];
}


#pragma mark - 布局
- (void)bulidLayout{
    self.view .backgroundColor = [UIColor whiteColor];
    CGRect rect = CGRectMake(0, 0, ScreenSize.width, 145);
    self.rpassgerView = [[RPassgerView alloc]initWithFrame:rect withPage:1];
    self.rpassgerView.bgImage.image = [UIImage imageNamed:@"salebg_2"];
    self.rpassgerView.cenImage.image = [UIImage imageNamed:@"sale_2"];

    [self.view addSubview:self.rpassgerView];
    
    
    rect = CGRectMake(0, 0, self.view.width, self.view.height- 158);
    self.tableView = [[UITableView alloc]initWithFrame:rect style:UITableViewStylePlain];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [self.tableView registerClass:[PassengerHeaderCell class] forHeaderFooterViewReuseIdentifier:passengerHeaderIdentify];
    self.tableView.tableHeaderView = self.rpassgerView;
    
    [self.view addSubview:self.tableView];
    
}
- (void)setValueInPassenger:(Compass *)compass  withType:(NSString *)type{
    self.rpassgerView.weekLabelStr = type;
    [self.rpassgerView setPassengerWithCompass:compass];
}


#pragma mark - tableViewDelegate
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView{
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return self.dataArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    
    static NSString *passengerCellIdentify = @"PassengerCellIdentify";

    PasengerCell *cell = [tableView dequeueReusableCellWithIdentifier:passengerCellIdentify];
    
    if(cell == nil) {
        cell = [[PasengerCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:passengerCellIdentify];
    }
    //没有选中风格
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    //取消分割线
    tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    
    Compass *test = _dataArr[indexPath.row];
    if(test != nil) {
        [cell updateCellWithFlow:test index:indexPath];
    }
    cell.detailBtn.tag = indexPath.row;
    [cell.detailBtn addTarget:self action:@selector(detailClick:) forControlEvents:UIControlEventTouchUpInside];
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return [PasengerCell cellHeight];
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    [[NSNotificationCenter defaultCenter]postNotificationName:KNOTIFICATION_GetNextDetailData object:nil userInfo:@{@"indexPath":indexPath}];
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    PassengerHeaderCell *headerView = [tableView dequeueReusableHeaderFooterViewWithIdentifier:passengerHeaderIdentify];
    
    if (headerView == nil) {
        headerView = [[PassengerHeaderCell alloc] initWithReuseIdentifier:passengerHeaderIdentify];
    }
    
    [headerView buildLayout:@"客流"];
    [headerView setTotalValue:[NSString stringWithFormat:@"共%ld家",(long)self.count]];
    [headerView changeTypeName:self.typeStr];
    return headerView;
}
- (void)detailClick:(UIButton *)btn{
    Compass *com = self.dataArr[btn.tag];
    NSObject *comObj = [NSNull null];
    if (com) {
        comObj = com;
    }
    [[NSNotificationCenter defaultCenter] postNotificationName:KNOTIFICATION_GoReportDetail object:nil userInfo:@{@"compass":comObj}];
}



- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return [PassengerHeaderCell viewHeight];
}



- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
