//
//  ChosePersonViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/6.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ChosePersonViewController.h"
#import "SurveyUser.h"
#import "User.h"
#define TopMargin 50
#define TableHeight 50
@interface ChosePersonViewController ()
{
}
@end

@implementation ChosePersonViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.tableView.header.lastUpdatedTimeKey = ChoosePersonUpdateDate;
    self.title = @"选择人员";
    [self fetchDataList:@"" tableStr:GXF_BASECLASS_USER];
}

- (void)getBaseDataFromServer{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        [strongSelf endRefreshing];
        [strongSelf fetchDataList:@"" tableStr:GXF_BASECLASS_USER];
    };
    
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getUserWithPage_number:0 page_size:100 success:succ failure:fail];
}
#pragma mark -成功
- (void)sureClick{
    if (self.isMoreChose) {
        NSMutableArray *arr = [[NSMutableArray alloc]init];
        for (NSIndexPath *index in self.indexArr) {
            User *user = self.dataArr[index.row];
            SurveyUser * survey = [[SurveyUser alloc]init];
            survey.userUuid = user.uuid;
            survey.userCode = user.login;
            survey.userName = user.name;
            [arr addObject:survey];
        }
        self.choseBaseInfo(arr);
    }else{
        NSMutableArray *arr = [[NSMutableArray alloc]init];
        if (self.dataArr.count > 0) {
            if (self.currentIndexPath) {
                User *user = self.dataArr[self.currentIndexPath.row];
                SurveyUser * survey = [[SurveyUser alloc]init];
                survey.userUuid = user.uuid;
                survey.userCode = user.login;
                survey.userName = user.name;
                [arr addObject:survey];
                self.choseBaseInfo(arr);
            }
        }
    }
    [self PopViewControllerAnimated:YES];
}

#pragma mark - 协议方法
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"MaskCell";
    MaskCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[MaskCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID totalWidth:ScreenSize.width totalHeight:TableHeight];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.Commitbtn.hidden = YES;
    }
    if (self.isMoreChose) {
        if ([self isHaveIndexPath:indexPath]) {
            cell.Commitbtn.hidden = NO;
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }else{
        if (self.currentIndexPath) {
            if (indexPath.row == self.currentIndexPath.row) {
                cell.Commitbtn.hidden = NO;
            }else{
                cell.Commitbtn.hidden = YES;
            }
        }else{
            cell.Commitbtn.hidden = YES;
        }
    }
    if (self.dataArr.count > 0) {
        if (indexPath.row == 0) {
            NSString *dateStr = [self.dataArr[indexPath.row] httpParameterString];
            cell.titleLabel.textColor = GXF_CONTENT_COLOR;
            [cell setTitleStr:[NSString stringWithFormat:@"上次更新时间:%@",dateStr]];
        }else{
            User *user =  self.dataArr[indexPath.row];
            [cell setTitleStr:user.name];
        }
    }
    return cell;
}
- (void)boxValueChanged:(NSNotification *)fication{
    NSString *tilkeStr = [IBTCommon trimmingCharacters:self.selectTextFiled.text];
    [self fetchDataList:tilkeStr tableStr:GXF_BASECLASS_USER];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

@end
