//
//  SeePurchaseNoticeViewController.m
//  XFFruit
//
//  Created by mac on 15/8/16.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "SeePurchaseNoticeViewController.h"
#import "NewPurchaseViewController.h"
#import "NoticeProduct.h"
#import "PurchaseNoticeCell.h"
#import "SurveyCell.h"
#import "HPGrowingTextView.h"
#import "NoticeProductViewController.h"
#import "FollowUpRecordViewController.h"
#define BottomHeight 50
#define LeftMargin 15
#define LeftWidth 100
#define leftWidth 40
#define LeftHeight 30
#define TopMargin 15
#define TableHeight 46
#define RightWidth 30
#define TitleSize 15

typedef enum : NSUInteger {
    EndTag = 3500,//结束
    NewTag,//新建
    AcceptTag,//接受
} BtnTag;


@interface SeePurchaseNoticeViewController ()<UITableViewDataSource,UITableViewDelegate,UITextFieldDelegate>

{
    UIScrollView *_scrollView;
    UIView *_purchaseView;
    UIView *_bottomView;
    NSArray *_leftArr;
    UIButton *_endBtn;
    UIButton *_rejectBtn;
    UITableView *mingXiTableView;
     NSMutableArray *_shopeArr;
     NSIndexPath *selectedCellIndexPath;
    UITextField *_titleField;
    UILabel *_productLabel;
    UILabel *_personLabel;
     NSString *title;
    HPGrowingTextView *_noteTextView;
    NSMutableArray *selectCellAry;
}
@property (nonatomic,strong)UILabel *billNumberLabel;
@property (nonatomic,strong)UILabel *titleLabel;
@property (nonatomic,strong)UILabel *createOperNameLabel;
@property (nonatomic,strong)UILabel *userLabel;
@property (nonatomic,strong)UILabel *stateLabel;
@property (nonatomic,strong)UILabel *countLabel;
@property (nonatomic,strong)UILabel *noteLabel;
@property (nonatomic,strong)UILabel *HeardLabel;
@property (nonatomic,strong)UILabel *FootLabel;
@property (nonatomic,strong)UIButton *addDetailedButton;
@end

@implementation SeePurchaseNoticeViewController

- (void)viewDidLoad {
    
    [super viewDidLoad];
    [self bulidLayout];
    [self getDataFromServer];
}
- (void)getDataFromServer{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message  = data[@"message"] ;
            if (success == 1) {
                NSDictionary *dictData = data[@"data"];
                PurchaseNotice *purchaseNotice = [[PurchaseNotice alloc]init];
                [purchaseNotice setValuesForKeysWithDictionary:dictData];
                NSMutableArray *productArr = [NSMutableArray array];
                for (NSDictionary *billDict in self.purchaseNotice.products) {
                    NoticeProduct *billProbuct = [NoticeProduct new];
                    [billProbuct setValuesForKeysWithDictionary:billDict];
                    [productArr addObject:billProbuct];
                }
                purchaseNotice.products = productArr;
                self.purchaseNotice = purchaseNotice;
                [strongSelf fetchtNoticeDetail];
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [IBTLoadingView showTips:@"     无记录     "];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getPurchaseNoticeDetailedWithPurchaseUuid:self.purchaseNotice.uuid success:succ failure:fail];
}
- (void)fetchtNoticeDetail{
    self.billNumberLabel.text = [IBTCommon checkString:self.purchaseNotice.billnumber];
    if ([self.purchaseNotice.state isEqualToString:PURCHASENOTICE_STATE_NOTACCEPTED]) {
        self.stateLabel.textColor = [UIColor redColor];
        self.stateLabel.text = @"未接受";
    }else if ([self.purchaseNotice.state isEqualToString:PURCHASENOTICE_STATE_PURCHASEING]) {
        self.stateLabel.textColor = [UIColor greenColor];
        self.stateLabel.text = @"采购中";
    }else if ([self.purchaseNotice.state isEqualToString:PURCHASENOTICE_STATE_FINISHED]) {
        self.stateLabel.textColor = [UIColor grayColor];
        self.stateLabel.text = @"已完成";
    }
    self.createOperNameLabel.text = [NSString stringWithFormat:@"%@%@",[IBTCommon checkString:self.purchaseNotice.create_operName],self.purchaseNotice.create_time.length > 10 ? [self.purchaseNotice.create_time substringToIndex:10] : self.purchaseNotice.create_time];

    self.titleLabel.text = [IBTCommon checkString:self.purchaseNotice.title];
    self.userLabel.text = [IBTCommon checkString:self.purchaseNotice.purchaserName];
    self.countLabel.text = [NSString stringWithFormat:@"%@",@"222"];
    self.noteLabel.text = [IBTCommon checkString:self.purchaseNotice.remark];
    [_shopeArr addObjectsFromArray:self.purchaseNotice.products];
    [mingXiTableView  reloadData];

    [self setNoteHeight];
}


#pragma mark - 视图初始化
- (void)bulidLayout{
    _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, ScreenSize.height - 64 - BottomHeight)];
    _scrollView.showsHorizontalScrollIndicator  = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    _scrollView.backgroundColor = XXFBgColor;
    [self.view addSubview:_scrollView];
    [self createBtn];
    [self createPurchaseView];
    [self  createMingXiTableView];//自定义
}
- (void)hiddenBottomBtn{
    
        _endBtn.hidden = YES;
        _rejectBtn.hidden = YES;
        CGRect scrollViewFrame = _scrollView.frame;
        scrollViewFrame.size.height = ScreenSize.height - 64;
        _scrollView.frame = scrollViewFrame;
}
- (void)createBtn{
    _rejectBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, ScreenSize.height  - 64 - BottomHeight +5, (ScreenSize.width - LeftMargin*3)/2, 40) target:self sel:@selector(btnClick:) tag:0 image:nil title:@"" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_SAVE_COLOR];
    [self.view addSubview:_rejectBtn];
    
    _endBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(CGRectGetMaxX(_rejectBtn.frame)+ LeftMargin, ScreenSize.height  - 64 - BottomHeight +5, (ScreenSize.width - LeftMargin*3)/2, 40) target:self sel:@selector(btnClick:) tag:0 image:nil title:@"" titleColor:[UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_COMMIT_COLOR];
    [self.view addSubview:_endBtn];
    
    if ([self.purchaseNotice.state isEqualToString:PURCHASENOTICE_STATE_NOTACCEPTED]) {
        if ([self checkIsPermission:NOTICE_PERMISSIONS_ACCEPTTASK] && [self checkIsPermission:NOTICE_PERMISSIONS_CREATEBILL]) {
            _rejectBtn.tag = AcceptTag;
            [_rejectBtn setTitle:@"接受任务" forState:UIControlStateNormal];
            _endBtn.tag = NewTag;
            _endBtn.backgroundColor = [UIColor lightGrayColor];
            _endBtn.enabled = NO;
            [_endBtn setTitle:@"新建采购单" forState:UIControlStateNormal];
        }else{
            if ([self checkIsPermission:NOTICE_PERMISSIONS_ACCEPTTASK]) {
                _rejectBtn.hidden = YES;
                _endBtn.frame = CGRectMake(LeftMargin, ScreenSize.height  - 64 - BottomHeight +5, ScreenSize.width - LeftMargin * 2, 40);
                _endBtn.tag = AcceptTag;
                [_endBtn setTitle:@"接受任务" forState:UIControlStateNormal];
            }else if ([self checkIsPermission:NOTICE_PERMISSIONS_CREATEBILL]) {
                _rejectBtn.hidden = YES;
                _endBtn.frame = CGRectMake(LeftMargin, ScreenSize.height  - 64 - BottomHeight +5, ScreenSize.width - LeftMargin * 2, 40);
                _endBtn.tag = NewTag;
                [_endBtn setTitle:@"新建采购单" forState:UIControlStateNormal];
            }else{
                [self hiddenBottomBtn];
            }
        }
    }else if([self.purchaseNotice.state isEqualToString:PURCHASENOTICE_STATE_PURCHASEING]){
        if([self checkIsPermission:NOTICE_PERMISSIONS_FINISH]){
            _rejectBtn.hidden = YES;
            _endBtn.frame = CGRectMake(LeftMargin, ScreenSize.height  - 64 - BottomHeight +5, ScreenSize.width - LeftMargin * 2, 40);
            _endBtn.tag = EndTag;
            [_endBtn setTitle:@"结束" forState:UIControlStateNormal];
        }else if([self checkIsPermission:NOTICE_PERMISSIONS_CREATEBILL]){
            _rejectBtn.hidden = YES;
            _endBtn.frame = CGRectMake(LeftMargin, ScreenSize.height  - 64 - BottomHeight +5, ScreenSize.width - LeftMargin * 2, 40);
            _endBtn.tag = NewTag;
            [_endBtn setTitle:@"新建采购单" forState:UIControlStateNormal];
        }else{
            [self hiddenBottomBtn];
        }
    }else if([self.purchaseNotice.state isEqualToString:PURCHASENOTICE_STATE_FINISHED]) {
        [self hiddenBottomBtn];
    }
}
- (BOOL)checkIsPermission:(NSString *)permission{
    for (NSString *per in [ICRUserUtil sharedInstance].permissions) {
        if ([per isEqualToString:permission]) {
            return YES;
        }
    }
    return NO;
}
- (void)btnClick:(UIButton *)btn{
    NSLog(@"%ld",(long)btn.tag);
    switch (btn.tag) {
        
        case EndTag:
        {
            [self dealByAction:@"end"];
        }
            break;
        case NewTag:
        {
            NewPurchaseViewController *nvc = [NewPurchaseViewController new];
            nvc.title = @"新建采购单";
            nvc.purchaseNotice = self.purchaseNotice;
            [self PushViewController:nvc animated:YES];
        }
            break;
        case AcceptTag:
        {
            [self dealByAction:@"accept"];
        }
            break;
        default:
            break;
    }
}
- (void)dealByAction:(NSString *)action{
    //保存
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message = data[@"message"];
            if (success == 1) {
                if ([action isEqualToString:@"accept"]) {
                    _stateLabel.text = @"发运中";
                    _endBtn.enabled = YES;
                    _endBtn.backgroundColor = GXF_COMMIT_COLOR;
                    _rejectBtn.enabled = NO;
                    _rejectBtn.backgroundColor = [UIColor lightGrayColor];
                }else{
                    [ICRUserUtil sharedInstance].needFresh = YES;
                    [self PopViewControllerAnimated:YES];
                }
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [IBTLoadingView showTips:@"操作异常"];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    if ([action isEqualToString:@"accept"]) {
        [[ICRHTTPController sharedController] acceptPurchaseNoticeWithUuid:self.purchaseNotice.uuid version:self.purchaseNotice.version success:succ failure:fail];
    }else{
        [[ICRHTTPController sharedController] finishPurchaseNoticeWithUuid:self.purchaseNotice.uuid version:self.purchaseNotice.version success:succ failure:fail];
    }
}
- (void)createMingXiTableView
{
    _bottomView= [[UIView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_purchaseView.frame) + TopMargin, ScreenSize.width, 200)];
    _bottomView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_bottomView];
    
    _shopeArr=[[NSMutableArray alloc]initWithObjects: nil];
    selectCellAry=[[NSMutableArray alloc]initWithCapacity:1000];
    mingXiTableView=[[UITableView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, _bottomView.height)];
    mingXiTableView.backgroundColor = [UIColor whiteColor];
    mingXiTableView.tag=1002;
    mingXiTableView.delegate=self;
    mingXiTableView.dataSource=self;
    UIView *footView2=[[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, TableHeight)];
    footView2.backgroundColor=[UIColor clearColor];
    NSArray *ary=[NSArray arrayWithObjects:@"商品",@"包装规格",@"包装数量", nil];
    CGFloat gipWidth = (ScreenSize.width-leftWidth-RightWidth)/3;
    
    for (int i=0; i< ary.count;i++ ) {
        UILabel *lable=[[UILabel alloc]init];
        if (i==0) {
            lable.frame=CGRectMake(leftWidth, 0, gipWidth,TableHeight);
        }
        if (i==1) {
            lable.frame=CGRectMake(leftWidth+gipWidth+1, 0, gipWidth,TableHeight);
        }
        if (i==2) {
            lable.frame=CGRectMake(leftWidth+2*gipWidth+2, 0, gipWidth,TableHeight);
        }
        lable.text=[ary objectAtIndex:i];
        lable.textColor=GXF_PLACEHOLDER_COLOR;
        lable.font = GXF_FIFTEENTEN_SIZE;
        [footView2 addSubview:lable];
    }
    
    UIView *footView3 = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, TableHeight)];
    footView3.backgroundColor=[UIColor clearColor];
    self.addDetailedButton=[UIButton  buttonWithType: UIButtonTypeCustom];
    [self.addDetailedButton  setFrame:CGRectMake(0, 0, ScreenSize.width, TableHeight)];
    [self.addDetailedButton setTitle:@">>查看跟进记录" forState:UIControlStateNormal];
    self.addDetailedButton.titleLabel.font = GXF_FIFTEENTEN_SIZE;
    [self.addDetailedButton addTarget:self action:@selector(addShopeDetailed) forControlEvents:UIControlEventTouchUpInside];
    [self.addDetailedButton setTitleColor:GXF_PLACEHOLDER_COLOR forState:UIControlStateNormal];
    self.FootLabel=[[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, footView3.size.height-1, footView3.size.width-2*LeftMargin, 1))];
    self.FootLabel.backgroundColor = HexColor(@"e5e5e5");
    self.FootLabel.font = FontSize(TitleSize);
    self.HeardLabel=[[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, 0, footView3.size.width-2*LeftMargin, 1))];
    self.HeardLabel.backgroundColor = HexColor(@"e5e5e5");
    self.HeardLabel.font = FontSize(TitleSize);
    [footView3 addSubview:self.addDetailedButton];
    [footView3 addSubview:self.HeardLabel];
    [footView3 addSubview:self.FootLabel];
    mingXiTableView.tableFooterView = footView3;
    mingXiTableView.tableHeaderView=footView2;
    [_bottomView addSubview:mingXiTableView];
}
- (void)createPurchaseView{
    
    _leftArr = @[@"单号:",@"创建人:",@"标题:",@"状态:",@"采购员:",@"合计基础数量:",@"备注:"];
    _purchaseView= [[UIView alloc]initWithFrame:CGRectMake(0, TopMargin, ScreenSize.width, LeftHeight*_leftArr.count +LeftMargin)];
    _purchaseView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_purchaseView];
    
    for (NSInteger i = 0 ; i < _leftArr.count; i++) {
        UILabel *leftLabel = [[UILabel alloc]initWithFrame:CGRectMake(LeftMargin, 10 + LeftHeight *i, LeftWidth, LeftHeight)];
        leftLabel.font = GXF_SEVENTEENTH_SIZE;
        leftLabel.text = _leftArr[i];
        leftLabel.textColor = GXF_DETAIL_COLOR;
        [_purchaseView addSubview:leftLabel];
        
        UILabel *rightLabel = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(leftLabel.frame), 10 + LeftHeight *i, _purchaseView.frame.size.width - LeftMargin - LeftWidth, LeftHeight)];
        rightLabel.font = GXF_SEVENTEENTH_SIZE;
        rightLabel.textColor = GXF_DETAIL_COLOR;
        
        if (i == 0) {
            self.billNumberLabel = rightLabel;
        }else if (i == 1) {
            self.createOperNameLabel = rightLabel;
        }else if(i == 2){
            self.titleLabel = rightLabel;
        }else if(i == 3){
            self.stateLabel = rightLabel;
        }else if(i == 4){
            self.userLabel = rightLabel;
        }else if(i == 5){
            leftLabel.width = 110;
            rightLabel.x = leftLabel.right;
            self.countLabel = rightLabel;
        }else if(i == _leftArr.count - 1){
            rightLabel.numberOfLines = 0;
            self.noteLabel = rightLabel;
        }
        [_purchaseView addSubview:rightLabel];
    }
}
- (void)setNoteHeight
{
    CGFloat height =  [self.noteLabel calculateHeight];
    
    CGRect noteFrame = self.noteLabel.frame;
    noteFrame.size.height = height;
    self.noteLabel.frame = noteFrame;
    
    CGFloat totalHeight = height + LeftHeight*_leftArr.count;
    CGRect purchaseFrame = _purchaseView.frame;
    purchaseFrame.size.height = totalHeight;
    _purchaseView.frame = purchaseFrame;
    
    
    CGRect bottomFrame = _bottomView.frame;
    bottomFrame.origin.y = CGRectGetMaxY(_purchaseView.frame) + TopMargin;
    _bottomView.frame = bottomFrame;
    
    _scrollView.contentSize = CGSizeMake(ScreenSize.width, totalHeight + CGRectGetHeight(_bottomView.frame) + TopMargin*2);
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    if ([tableView isEqual:mingXiTableView])
    {
        return 1;
    }
    
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    if ([tableView isEqual:mingXiTableView])
    {
        return _shopeArr.count;
    }
    return 1;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
   
    if ([tableView isEqual:mingXiTableView])
    {
        
        static NSString *CellID = @"CellID";
        PurchaseNoticeCell *Cell = [tableView dequeueReusableCellWithIdentifier:CellID];
        
        if (Cell == nil) {
            Cell = [[PurchaseNoticeCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellID];
            Cell.isButtonhidden=YES;
            tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
            Cell.selectionStyle = UITableViewCellSelectionStyleNone;
            
            //            Cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;向左箭头
            //            [self  showShopDetail:Cell indexPath:indexPath];
        }
        [self  showShopDetail:Cell indexPath:indexPath];
        if (Cell.isSelected==YES) {
            Cell.arrowView.image = [UIImage imageNamed:@"arrowdown"];
            Cell.button.hidden=YES;
            Cell.backgroundColor=XXFBgColor;
            Cell.subSview.hidden=NO;
        }else
        {
            Cell.arrowView.image = [UIImage imageNamed:@"arrowright"];
            Cell.backgroundColor=[UIColor whiteColor];
            Cell.subSview.hidden=YES;
            
        }
         Cell.button.hidden=YES;
        Cell.button.tag=indexPath.row;
        [Cell.button addTarget:self action:@selector(didtoucher:) forControlEvents:UIControlEventTouchUpInside];
       
        return Cell;
        
    }
    return nil;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
   
    
        
    if ([tableView isEqual:mingXiTableView])
    {
        if ([self  comperIndexpath:indexPath]) {
            return TableHeight*3;
        }else
        {
            return TableHeight;
        }
        
    }
    return TableHeight;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if ([tableView isEqual:mingXiTableView])
    {
        PurchaseNoticeCell *Cell=(PurchaseNoticeCell*)[mingXiTableView cellForRowAtIndexPath:indexPath ];
        if (Cell.isSelected==NO) {
            Cell.isSelected=YES;
            [selectCellAry addObject:indexPath];
        }else{
            Cell.isSelected=NO;
            [selectCellAry removeObject:indexPath];
        }
        
        selectedCellIndexPath = indexPath;
        
        
        [mingXiTableView reloadData];
    }
}


-(BOOL)comperIndexpath:(NSIndexPath *)indexPath
{
    for (NSIndexPath *path in selectCellAry) {
        if (path.row == indexPath.row) {
            return YES;
        }
    }
    return NO;
}

//查看跟进记录
-(void)addShopeDetailed
{
    FollowUpRecordViewController *nvc = [FollowUpRecordViewController new];
    nvc.title = @"查看跟进记录";
    nvc.purchaseNotice=self.purchaseNotice;
    [self PushViewController:nvc animated:YES];
}
-(void)showShopDetail:(PurchaseNoticeCell*)Cell indexPath:(NSIndexPath *)indexPath
{
    NoticeProduct *noticeProduct=[_shopeArr objectAtIndex:indexPath.row];
    Cell.SpLabel.text=noticeProduct.productName;//商品
    Cell.DjLabel.text=noticeProduct.packUnit;//包装单价
    Cell.BzggLabel.text=[noticeProduct.qpc stringValue];//包装规格
    Cell.BzslLabel.text=[noticeProduct.qpcQuantity stringValue];//包装数量
    Cell.packageSpecification.text=[noticeProduct.qpc stringValue];//包装规格
    Cell.foundationQuantity.text=[noticeProduct.quantity stringValue];//基础数量
    Cell.remark.text=noticeProduct.remark;//备注
    
}
//编辑
- (void)didtoucher:(UIButton*)button
{
    NoticeProductViewController *nvc = [NoticeProductViewController new];
    NSIndexPath *indexPath = [NSIndexPath indexPathForRow:0 inSection:button.tag];
    NoticeProduct *shopDetail=[_shopeArr objectAtIndex:button.tag];
    
    if (indexPath) {
        nvc.navTitle = @"编辑费用";
        nvc.indexPath = indexPath;
        nvc.noticeProduct = shopDetail;
    }
    nvc.choseNoticeProduct = ^(NoticeProduct *fee,NSIndexPath *indexPath){
        if (fee) {
            [_shopeArr replaceObjectAtIndex:indexPath.row withObject:fee];
            [mingXiTableView reloadData];
            
        }
    };
    nvc.deleteNoticeProduct = ^(NoticeProduct *fee,NSIndexPath *indexPath){
        if (fee) {
            [_shopeArr removeObjectAtIndex:indexPath.row];
            [mingXiTableView reloadData];
            
        }
    };
    
    [self PushViewController:nvc animated:YES];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
