//
//  ShopDetaileViewController.m
//  XFFruit
//
//  Created by mac on 15/8/19.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "ShopDetaileViewController.h"
#import "SurveyCell.h"
#import "HPGrowingTextView.h"
#import "StartTimeView.h"
#import "ChosePersonViewController.h"
#import "ChooseProductViewController.h"
#import "ChooseProductUnitViewController.h"
#import "GXFSearchVendorViewController.h"
#import "GXFProductUnit.h"
#define LeftMargin 15
#define BtnHeight 44
#define TableHeight 46
#define CornerRadius 5
#define TitleSize 15
#define BtnSize 19
#define TotalHeight 432
#define KeyboardHeight 258
#define DateViewHeight 300
typedef enum : NSUInteger {
    SaveTag = 2000,
    CommitTag,
} BtnTag;
@interface ShopDetaileViewController ()<UITableViewDataSource,UITableViewDelegate,HPGrowingTextViewDelegate,UITextFieldDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
    UILabel *_productLabel;
    UILabel *_PackagingLable;
    HPGrowingTextView *_noteTextView;
    UITextField *merchandise;         //商品
    UITextField *packageSpecification;//包装规格
    UITextField *packageQuantity;     //包装数量
    UITextField *packageUnit;         //包装单位
    UITextField *foundationQuantity;  //基础数量
    UITextField *foundationUnitPrice; //基础单价
    UITextField *packageUnitPrice;    //包装单价
    UITextField *totalMoney;          //总金额
    UITextField *remark;              //备注
}
@property (nonatomic,strong)NSString *titleStr;
@property (nonatomic,strong)NSString *productCodeStr;
@property (nonatomic,strong)NSString *productNameStr;
@property (nonatomic,strong)NSString *productUuidStr;
@property (nonatomic,strong)NSString *beginDateStr;
@property (nonatomic,strong)NSString *endDateStr;
@property (nonatomic,strong)NSString *remarkStr;
@property (nonatomic,strong)NSMutableArray *users;
@end

@implementation ShopDetaileViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = self.navTitle;
    [self initData];
    [self setupSubviews];
}
- (void)initData{
    merchandise=[[UITextField alloc]init];
    packageUnit=[[UITextField alloc]init];
    merchandise.text=packageUnit.text=NULL;
    _dataArr = [NSMutableArray array];
    self.users = [NSMutableArray array];
    [_dataArr addObject:@"商品"];
    [_dataArr addObject:@"包装规格"];
    [_dataArr addObject:@"包装数量"];
    [_dataArr addObject:@"包装单位"];
    [_dataArr addObject:@"基础数量"];
    [_dataArr addObject:@"基础单价"];
    [_dataArr addObject:@"包装单价"];
    [_dataArr addObject:@"总金额"];
    [_dataArr addObject:@"备注"];
    
}

-(void)setupSubviews
{    
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, 0,ScreenSize.width, ScreenSize.height - 64 - LeftMargin)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.bounces = NO;
    _tableView.delegate = self;
    _tableView.dataSource = self;
    
    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 50)];
    
    UIButton *saveBtn =  [IBTCustomButtom creatButtonWithFrame:CGRectMake(LeftMargin, 10, (ScreenSize.width - LeftMargin*3)/2, BtnHeight) target:self sel:@selector(btnClick:) tag:SaveTag image:nil title:@"删除" titleColor: [UIColor whiteColor] isCorner:YES corner:CornerRadius bgColor:GXF_SAVE_COLOR];
    [footView addSubview:saveBtn];
    
    UIButton *commitBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(saveBtn.frame.origin.x + saveBtn.frame.size.width + LeftMargin, 10, (ScreenSize.width - LeftMargin*3)/2, BtnHeight) target:self sel:@selector(btnClick:) tag:CommitTag image:nil title:@"保存" titleColor: [UIColor whiteColor] isCorner:YES corner:CornerRadius bgColor:GXF_COMMIT_COLOR];
    [footView addSubview:commitBtn];
        _tableView.tableFooterView = footView;
    [self.view addSubview:_tableView];
    
}
- (void)setviewsData
{
    if (self.shopDetail!=nil) {
       
       _productLabel.text=self.shopDetail.merchandise;//商品
        merchandise.text=self.shopDetail.merchandise;
       
        packageUnit.text=self.shopDetail.packageUnit;
        _PackagingLable.text=self.shopDetail.packageUnit;//包装单位
        packageSpecification.text=self.shopDetail.packageSpecification;//包装规格
        packageQuantity.text=self.shopDetail.packageQuantity;     //包装数量
       
        foundationQuantity.text=self.shopDetail.foundationQuantity;  //基础数量
        foundationUnitPrice.text=self.shopDetail.foundationUnitPrice; //基础单价
        packageUnitPrice.text=self.shopDetail.packageUnitPrice;    //包装单价
        totalMoney.text=self.shopDetail.totalMoney;          //总金额
        remark.text=self.shopDetail.remark;
        self.productCodeStr = self.shopDetail.product_code;
        self.productUuidStr = self.shopDetail.product_uuid;
        _productLabel.textColor=GXF_CONTENT_COLOR;
         _PackagingLable.textColor=GXF_CONTENT_COLOR;
    }
}
#pragma mark - 按钮点击事件
- (void)btnClick:(UIButton *)btn{
    switch (btn.tag) {
        case SaveTag://删除
        {
            if (self.shopDetail!=nil) {
                ShopDetail *shopDetail=self.shopDetail;

                if (shopDetail.IsXiuGai==YES) {
                    shopDetail.IsDeleted=YES;
                    self.choseShopDetail(shopDetail);//回调
                    [self PopViewControllerAnimated:YES];
                }else
                {
                    [self  clearShopDetail];
                }
            }else
            {
                 [self  clearShopDetail];
            }
        }
            break;
        case CommitTag:
        {
            if ([self informationComplete]) {
                ShopDetail *shopDetail=self.shopDetail;
                shopDetail.IsDeleted=NO;
                self.choseShopDetail(shopDetail);//回调
                [self PopViewControllerAnimated:YES];
            }
        }
            break;
        default:
            break;
    }
}
- (void)clearShopDetail
{
    _productLabel.text=@"选择商品";//商品
    merchandise.text=@"";
    
    packageUnit.text=@"";
    _PackagingLable.text=@"选择包装单位";//包装单位
    packageSpecification.text=@"";//包装规格
    packageQuantity.text=@"";     //包装数量
    
    foundationQuantity.text=@"";  //基础数量
    foundationUnitPrice.text=@""; //基础单价
    packageUnitPrice.text=@"";    //包装单价
    totalMoney.text=@"0";          //总金额
    remark.text=@"";
    _productLabel.textColor=GXF_PLACEHOLDER_COLOR;
    _PackagingLable.textColor=GXF_PLACEHOLDER_COLOR;
}
- (BOOL)informationComplete{
    if (!self.shopDetail) {
        self.shopDetail=[[ShopDetail alloc]init];
    }
    self.shopDetail.merchandise=merchandise.text;
    self.shopDetail.packageSpecification=packageSpecification.text;
    self.shopDetail.packageQuantity=packageQuantity.text;
    self.shopDetail.packageUnit=packageUnit.text;
    self.shopDetail.foundationQuantity=foundationQuantity.text;
    self.shopDetail.foundationUnitPrice=foundationUnitPrice.text;
    self.shopDetail.packageUnitPrice=packageUnitPrice.text;
    self.shopDetail.totalMoney=totalMoney.text;
    self.shopDetail.remark=remark.text;
    self.shopDetail.product_code = self.productCodeStr;
    self.shopDetail.product_uuid = self.productUuidStr;
    if (merchandise.text.length == 0 ) {
        ShowMessage(@"商品不能为空");
        return NO;
    }
    if (packageSpecification.text.length == 0 ) {
        ShowMessage(@"包装规格不能为空");
        return NO;
    }
    if (packageQuantity.text.length == 0 ) {
        ShowMessage(@"包装数量不能为空");
        return NO;
    }
    if (packageUnit.text.length == 0) {
        ShowMessage(@"包装单位不能为空");
        return NO;
    }
    if (foundationQuantity.text.length == 0) {
        ShowMessage(@"基础数量不能为空");
        return NO;
    }
    if (foundationUnitPrice.text.length == 0) {
        ShowMessage(@"基础单价不能为空");
        return NO;
    }if (packageUnitPrice.text.length == 0) {
        ShowMessage(@"总金额不能为空");
        return NO;
    }
    if (remark.text.length == 0) {
        ShowMessage(@"备注不能为空");
        return NO;
    }
    return YES;
    
}
#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return _dataArr.count;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    return TableHeight;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"cellID";
    SurveyCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (indexPath.row==0||indexPath.row==3) {
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
        [self createViewInCell:cell indexPath:indexPath];
    }
    [cell setTitleStr:_dataArr[indexPath.row]];
    return cell;
}

-  (void)createViewInCell:(SurveyCell *)cell indexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 0||indexPath.row==3) {
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:(CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableHeight))];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = GXF_PLACEHOLDER_COLOR;
        contentLabel.font = FontSize(TitleSize);
        [cell.contentView addSubview:contentLabel];
        if (indexPath.row==0) {
            _productLabel = contentLabel;
            contentLabel.text = @"选择商品";
        }else if (indexPath.row==3)
        {
            _PackagingLable = contentLabel;
            contentLabel.text = @"选择包装单位";
        }
        
    }else
    {
        UITextField  *textField = [[UITextField alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-15, TableHeight)];
        textField.textAlignment = NSTextAlignmentRight;
        textField.textColor = GXF_CONTENT_COLOR;
        textField.font = FontSize(15);
        textField.returnKeyType = UIReturnKeyDone;
        textField.delegate = self;
        [cell.contentView addSubview:textField];
        if (indexPath.row==1) {
            packageSpecification=textField;//包装规格
            textField.placeholder = @"输入包装规格";
        }else if (indexPath.row==2)
        {
            packageQuantity=textField;     //包装数量
            textField.placeholder = @"输入包装数量";
        }else if (indexPath.row==4)
        {
            foundationQuantity=textField;  //基础数量
            textField.placeholder = @"输入基础数量";
        }else if (indexPath.row==5)
        {
            foundationUnitPrice=textField; //基础单价
            textField.placeholder = @"输入基础单价";
            textField.frame = CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-30, TableHeight);
            UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(textField.frame) + 5, 0, 20, TableHeight)];
            label.text = @"元";
            label.textColor = GXF_CONTENT_COLOR;
            label.font = GXF_FIFTEENTEN_SIZE;
            [cell.contentView addSubview:label];
        }else if (indexPath.row==6)
        {
            packageUnitPrice=textField;    //包装单价
            textField.placeholder = @"输入包装单价";
             textField.frame = CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-30, TableHeight);
            UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(textField.frame) + 5, 0, 20, TableHeight)];
            label.text = @"元";
            label.textColor = GXF_CONTENT_COLOR;
            label.font = GXF_FIFTEENTEN_SIZE;
            [cell.contentView addSubview:label];
        }else if (indexPath.row==7)
        {
            totalMoney=textField;          //总金额
            textField.placeholder = @"输入总金额";
            textField.text = @"0";
            textField.frame = CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-30, TableHeight);
            textField.textColor = [UIColor redColor];
            
            UILabel *label = [[UILabel alloc]initWithFrame:CGRectMake(CGRectGetMaxX(textField.frame)+ 5, 0, 20, TableHeight)];
            label.text = @"元";
            label.textColor = GXF_CONTENT_COLOR;
            label.font = GXF_FIFTEENTEN_SIZE;
            [cell.contentView addSubview:label];
            
        }else if (indexPath.row==8)
        {
            remark=textField;              //备注
            textField.placeholder = @"输入备注内容";
        }
    }
     [self  setviewsData];
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    
    if(indexPath.row == 0){
        ChooseProductViewController *cvc = [ChooseProductViewController new];
        cvc.choseBaseInfo = ^(NSArray  *products){
            Product *product=products [0];
            _productLabel.text = [NSString stringWithFormat:@"%@[%@]",product.name,product.code];
            merchandise.text=product.name;
            _productLabel.textColor = GXF_CONTENT_COLOR;
            self.productNameStr = product.name;
            self.productUuidStr = product.uuid;
            self.productCodeStr = product.code;
        };
        cvc.isMoreChose = NO;
        [self PushViewController:cvc animated:YES];
    }else if (indexPath.row ==3)
    {
        ChooseProductUnitViewController *cvc = [ChooseProductUnitViewController new];
        cvc.choseBaseInfo = ^(NSArray  *products){
            if (products.count > 0) {
                GXFProductUnit *productUnit=products [0];
                _PackagingLable.text = [NSString stringWithFormat:@"%@",productUnit.name];
                packageUnit.text= [NSString stringWithFormat:@"%@",productUnit.name];
                _PackagingLable.textColor = GXF_CONTENT_COLOR;
            }
        };
        cvc.isMoreChose = NO;
        [self PushViewController:cvc animated:YES];
    }
}

#pragma mark delegate
- (BOOL)growingTextViewShouldReturn:(HPGrowingTextView *)growingTextView{
    [_noteTextView resignFirstResponder];
    return YES;
}
- (void)keyboardHidden{
    [_noteTextView resignFirstResponder];
}

- (void)viewWillDisappear:(BOOL)animated{
    [super viewWillDisappear:animated];
    
}

/*
 #pragma mark - Navigation
 
 // In a storyboard-based application, you will often want to do a little preparation before navigation
 - (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
 // Get the new view controller using [segue destinationViewController].
 // Pass the selected object to the new view controller.
 }
 */

@end
