//
//  GXFPopView.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/11.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "GXFPopView.h"
#import "GXFPopCell.h"
#define GXFPOpView_LeftMargin 20
#define GXFPOpView_ContentHeight 200
#define GXFPOpView_TopHeight 44

@interface GXFPopView ()<UITableViewDelegate,UITableViewDataSource>
@property (nonatomic,strong)UITableView *tableView;
@property (nonatomic,strong)NSArray *titleArr;
@end


@implementation GXFPopView

- (instancetype)initWithFrame:(CGRect)frame withArr:(NSArray *)titleArr{
    self = [super initWithFrame:frame];
    if (self) {
        self.titleArr = titleArr;
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout{
    self.backgroundColor = RGBA(0, 0, 0, 0.5);
    UIView *bgView = [[UIView alloc]initWithFrame:CGRectMake(GXFPOpView_LeftMargin, (ScreenSize.height - GXFPOpView_ContentHeight)/2, ScreenSize.width - GXFPOpView_LeftMargin*2, GXFPOpView_ContentHeight)];
    bgView.backgroundColor = XXFBgColor;
    bgView.layer.cornerRadius = 4;
    bgView.layer.masksToBounds = YES;
    [self addSubview:bgView];
    
    
    UILabel *titlelabel = [[UILabel alloc]initWithFrame:CGRectMake(10, 0, CGRectGetWidth(bgView.frame)- 20, GXFPOpView_TopHeight-1)];
    titlelabel.text = @"选择添加项目";
    titlelabel.textColor = GXF_PopView_COLOR;
    [bgView addSubview:titlelabel];
    
    UILabel *lineLabel = [[UILabel alloc]initWithFrame:CGRectMake(0, GXFPOpView_TopHeight-1, CGRectGetWidth(bgView.frame), 1)];
    lineLabel.backgroundColor = GXF_PopView_COLOR;
    [bgView addSubview:lineLabel];
    
    self.tableView = [[UITableView alloc]initWithFrame:CGRectMake(0, GXFPOpView_TopHeight, CGRectGetWidth(bgView.frame), GXFPOpView_ContentHeight - GXFPOpView_TopHeight*2) style:UITableViewStylePlain];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    [bgView addSubview:self.tableView];

    UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
    btn.frame = CGRectMake(0, CGRectGetHeight(bgView.frame)- GXFPOpView_TopHeight, CGRectGetWidth(bgView.frame), GXFPOpView_TopHeight);
    [btn setTitle:@"返回" forState:UIControlStateNormal];
    [btn addTarget:self action:@selector(backClick) forControlEvents:UIControlEventTouchUpInside];
    [btn setTitleColor:GXF_CONTENT_COLOR forState:UIControlStateNormal];
    
    [bgView addSubview:btn];
    
}
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.titleArr.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellID = @"SurveyID";
    GXFPopCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[GXFPopCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    if (self.titleArr.count > 0) {
        NSString *titleStr = self.titleArr[indexPath.row];
        [cell setTitleStr:titleStr];
        
    }
    return cell;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    NSString *str = self.titleArr[indexPath.row];
    if ([self.delegate respondsToSelector:@selector(selectRowTitle:)]) {
        [self.delegate selectRowTitle:str];
    }
}
- (void)backClick{
    if ([self.delegate respondsToSelector:@selector(clearFromSuper)]) {
        [self.delegate clearFromSuper];
    }
}

@end
