//
//  SurveyCell.m
//  XFFurit
//
//  Created by 陈俊俊 on 15/8/1.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "SurveyCell.h"
#define TitleSize 15
#define LeftMargin 15
@implementation SurveyCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier{
    
    self =  [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self bulidLayout];
    }
    return self;
}

- (void)bulidLayout
{
    
    self.titleLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, 0, 100, 44))];
    self.titleLabel.textAlignment= NSTextAlignmentLeft;
    self.titleLabel.textColor = GXF_LEFTSIX_COLOR;
    self.titleLabel.font = GXF_FIFTEENTEN_SIZE;
    
    self.lineLabel = [[UILabel alloc]initWithFrame:(CGRectMake(LeftMargin, 44-1, ScreenSize.width - LeftMargin * 2, 1))];
    self.lineLabel.backgroundColor = GXF_LINE_COLOR;
    self.lineLabel.font = GXF_FIFTEENTEN_SIZE;
    [self.contentView addSubview:self.titleLabel];
    [self.contentView addSubview:self.lineLabel];
}
- (void)setTitleStr:(NSString *)str
{
    self.titleLabel.text = str;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
