//
//  NewTransportViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/9/6.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "NewTransportViewController.h"
#import "TopTransportView.h"
#import "BottomTransportView.h"
#import "TransportPurchaseViewController.h"
#import "NewCostViewController.h"
#import "TransportPdtDetail.h"
#import "FeeAcountDetail.h"
#import "TransportViewController.h"
#import "ShopDetaileViewController.h"
typedef enum : NSUInteger {
    SaveTag = 7000,
    CommitTag,
} BtnTag;

#define TopHeight 284
#define BottomHeight 300
#define SpaceHeight 20
#define BottomViewHeight 60
@interface NewTransportViewController ()<TopTransportViewDelegate,UIScrollViewDelegate,UIAlertViewDelegate>
{
    UIScrollView *_scrollView;
    TopTransportView *_sheetView;
    BottomTransportView *_bottomView;
    id uuidObject;
    id billNumberObject;
    NSNumber *versionObject;
}

@end

@implementation NewTransportViewController
- (void)dealloc{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}
- (instancetype)init{
    self = [super init];
    if (self) {
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(choseTransportPurchase) name:KNOTIFICATION_ChoseTransportPurchase object:nil];
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(addTransportCost:) name:KNOTIFICATION_AddTransportCost object:nil];
        [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(addPurchaseProduct:) name:KNOTIFICATION_AddPurchaseProduct object:nil];
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    //布局
    [self bulidLayout];
    uuidObject = [NSNull null];
    billNumberObject = [NSNull null];
    versionObject = [NSNumber numberWithInteger:0];
    if (self.transport) {
        [self getDataFromServer];
    }
}

- (void)getDataFromServer{
    __weak typeof(self)weakSelf = self;
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        __strong __typeof(weakSelf)strongSelf = weakSelf;
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message  = data[@"message"] ;
            if (success == 1) {
                NSDictionary *dictData = data[@"data"];
                Transport *transport = [[Transport alloc]init];
                [transport setValuesForKeysWithDictionary:dictData];
                self.transport = transport;
                [strongSelf fetchtTransportDetail];
            }else{
                [IBTLoadingView showTips:message];
            }
        }else{
            [IBTLoadingView showTips:@"     无记录     "];
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    [IBTLoadingView showProgressLabel:@"正在加载..."];
    [[ICRHTTPController sharedController] getTransportResultWithTransportUuid:self.transport.uuid success:succ failure:fail];
}

- (void)fetchtTransportDetail
{
    _sheetView.transport = self.transport;
    [_bottomView refreshCost:self.transport.accountDetails];
    [_bottomView refreshTranProduct:self.transport.pdtDetails];
}

- (void)bulidLayout{
    self.view.backgroundColor  = XXFBgColor;
    _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0,0, ScreenSize.width, ScreenSize.height- 64 - BottomViewHeight )];
    _scrollView.showsHorizontalScrollIndicator  = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    _scrollView.contentSize = CGSizeMake(ScreenSize.width, TopHeight+ BottomHeight + SpaceHeight*2);
    [self.view addSubview:_scrollView];
    
    
    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, ScreenSize.height - BottomViewHeight - 64, ScreenSize.width, BottomViewHeight)];
    UIButton *saveBtn =  [IBTCustomButtom creatButtonWithFrame:CGRectMake(15, 8, (ScreenSize.width - 15*3)/2, 44) target:self sel:@selector(btnClick:) tag:SaveTag image:nil title:@"保存" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_SAVE_COLOR];
    [footView addSubview:saveBtn];
    
    UIButton *commitBtn = [IBTCustomButtom creatButtonWithFrame:CGRectMake(CGRectGetMaxX(saveBtn.frame) + 15, 8, (ScreenSize.width - 15*3)/2, 44) target:self sel:@selector(btnClick:) tag:CommitTag image:nil title:@"提交" titleColor: [UIColor whiteColor] isCorner:YES corner:5 bgColor:GXF_COMMIT_COLOR];
    [footView addSubview:commitBtn];
    
    [self.view addSubview:footView];
    
    _sheetView = [[TopTransportView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, TopHeight)];
    _sheetView.delegate = self;
    [_scrollView addSubview:_sheetView];
    
    _bottomView = [[BottomTransportView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_sheetView.frame) + 20, ScreenSize.width,BottomHeight) withHidden:NO];
    _bottomView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_bottomView];
}
- (void)btnClick:(UIButton *)btn{
    switch (btn.tag) {
        case SaveTag:
        {
            if ([self checkTransport]) {
                [self getDataFromServer:TRANSPORT_STATE_INITIAL msg:@"正在保存..."];
            }
        }
            break;
        case CommitTag:{
            if ([self checkTransport]) {
                UIAlertView *alertView = [[UIAlertView alloc]initWithTitle:@"温馨提示" message:@"请确认提交" delegate:self cancelButtonTitle:@"取消" otherButtonTitles:@"确认", nil];
                alertView.delegate = self;
                [alertView show];
            }
        }
            break;
        default:
            break;
    }
}
- (void)getDataFromServer:(NSString *)state msg:(NSString *)msg{
    //保存
    void(^succ)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        if (data) {
            NSInteger success = [data[@"success"] integerValue];
            NSString *message = data[@"message"];
            if (success == 1) {
                //成功
                if ([state isEqualToString:PURCHASE_STATE_INITIAL]) {//保存成功
                    NSString *uuidS = data[@"data"][@"uuid"];
                    NSString *billNumberS = data[@"data"][@"billNumber"];
                    NSNumber *versionN = data[@"data"][@"version"];
                    uuidObject = uuidS;
                    billNumberObject = billNumberS;
                    versionObject = versionN;
                    [IBTLoadingView showTips:[NSString stringWithFormat:@"当前单据%@已保存成功",billNumberS]];
                }else{//提交成功
                    TransportViewController *svc = [TransportViewController new];
                    svc.title = @"发运单列表";
                    [self PushViewController:svc animated:YES];
                }
            }else{
                [IBTLoadingView showTips:message];
            }
        }
    };
    void(^fail)(id) = ^(id data) {
        [IBTLoadingView hideHUDWithText:nil];
        [IBTLoadingView showTips:data];
    };
    
    if(self.transport.uuid.length > 0 && uuidObject == [NSNull null]){
        uuidObject = self.transport.uuid;
    }
    if (self.transport.billnumber > 0 && billNumberObject == [NSNull null]) {
        billNumberObject = self.transport.billnumber;
    }
    if (self.transport && [versionObject integerValue] == 0) {
        versionObject = self.transport.version;
    }
    NSMutableArray *billProducts = [NSMutableArray array];
    for (TransportPdtDetail *pdtDetail in _bottomView.productVC.transportProductArr) {
        [billProducts  addObject:[pdtDetail dictForCommit]];
    }
    NSMutableArray *costs = [NSMutableArray array];
    for (FeeAcountDetail *fee in _bottomView.costVC.costArr) {
        [costs  addObject:[fee dictForCommit]];
    }
//    self.state = state;
    
    NSDictionary *dict = @{@"uuid":uuidObject,
                           @"version":versionObject,
                           @"billnumber":billNumberObject,
                           @"enterprise":[ICRUserUtil sharedInstance].orgId,
                           @"state":state,
                           @"warehouseUuid":[IBTCommon checkString:_sheetView.warehouseUuid],
                           @"warehouseCode":[IBTCommon checkString:_sheetView.warehouseCode],
                           @"warehouseName":[IBTCommon checkString:_sheetView.warehouseName],
                           @"rwarehouseUuid":[IBTCommon checkString:_sheetView.rwarehouseUuid],
                           @"rwarehouseCode":[IBTCommon checkString:_sheetView.rwarehouseCode],
                           @"rwarehouseName":[IBTCommon checkString:_sheetView.rwarehouseName],
                           @"carnumber":[IBTCommon checkString:_sheetView.carnumber],
                           @"type":[IBTCommon checkString:_sheetView.type],
                           @"carphone":[IBTCommon checkString:_sheetView.carphone],
                           @"note":_sheetView.note,
                           @"pdtDetails":billProducts,
                           @"accountDetails":costs};
    [IBTLoadingView showProgressLabel:msg];
    [[ICRHTTPController sharedController] saveTransportWithData:dict success:succ failure:fail];
}



- (BOOL)checkTransport{
    _sheetView.note = _sheetView.remarkTextView.text;
    _sheetView.carnumber = _sheetView.carTextFiled.text;
    _sheetView.carphone = _sheetView.phoneTextFiled.text;

    if (_sheetView.warehouseName.length == 0 ) {
        ShowMessage(@"发货仓库不能为空");
        return NO;
    }
    if (_sheetView.rwarehouseUuid.length == 0 ) {
        ShowMessage(@"收货仓库不能为空");
        return NO;
    }
    
    if (_sheetView.type.length == 0 ) {
        ShowMessage(@"运输类型不能为空");
        return NO;
    }
    if (_sheetView.carnumber.length == 0) {
        ShowMessage(@"车牌号不能为空");
        return NO;
    }
    if (_sheetView.carphone.length == 0) {
        ShowMessage(@"司机电话不能为空");
        return NO;
    }
    if (_bottomView.productVC.transportProductArr.count == 0) {
        ShowMessage(@"商品不能为空");
        return NO;
    }
    if (_bottomView.costVC.costArr.count == 0) {
        ShowMessage(@"费用不能为空");
        return NO;
    }
    return YES;
}



- (void)choseTransportPurchase{
    TransportPurchaseViewController *tpv = [TransportPurchaseViewController new];
    tpv.getProchaseProduct = ^(NSArray *products){
        if (products.count > 0) {
            [_bottomView reProduct:products];
        }
    };
    [self PushViewController:tpv animated:YES];
}
- (void)addTransportCost:(NSNotification *)fination{
    
    NewCostViewController *nvc = [NewCostViewController new];
    NSIndexPath *indexPath = [[fination userInfo] objectForKey:@"indexPath"];
    FeeAcountDetail *fee = [[fination userInfo] objectForKey:@"feeAccountDetail"];

    if (indexPath) {
        nvc.navTitle = @"编辑费用";
        nvc.indexPath = indexPath;
        nvc.accountDetail = fee;
    }else{
        nvc.navTitle = @"添加费用";
    }
    nvc.getTransportCost = ^(FeeAcountDetail *fee,NSIndexPath *indexPath){
        if (fee) {
            [_bottomView refreshCost:fee indexPath:indexPath];
        }
    };
    nvc.deleteTransportCost = ^(FeeAcountDetail *fee,NSIndexPath *indexPath){
        if (fee) {
            [_bottomView refreshDelCost:fee indexPath:indexPath];
        }
    };
    [self PushViewController:nvc animated:YES];

}
- (void)addPurchaseProduct:(NSNotification *)fication{
    TransportPdtDetail *billProduct = [[fication userInfo] objectForKey:@"transportPdtDetail"];
    NSInteger indexTag = [[[fication userInfo] objectForKey:@"indexTag"] integerValue];
    
    ShopDetaileViewController *svc = [[ShopDetaileViewController alloc] init];
    if (billProduct) {
        svc.navTitle = @"编辑商品";
        ShopDetail *shopDetail=[self coverShopDetail:billProduct];
        shopDetail.IsXiuGai=YES;
        svc.choseShopDetail = ^(ShopDetail *Detail){
            TransportPdtDetail *tdetail = [self coverTransportPdtDetail:Detail];
            if (Detail.IsDeleted) {
                [_bottomView refreshDelProduct:tdetail tag:indexTag];
            }else{
                [_bottomView refreshEditProduct:tdetail tag:indexTag];
            }
        };
        svc.shopDetail=shopDetail;
    }else{
        svc.navTitle = @"添加商品";
        // 回调
        svc.choseShopDetail = ^(ShopDetail *shopDetail){
            TransportPdtDetail *tdetail = [self coverTransportPdtDetail:shopDetail];
            [_bottomView refreshProduct:tdetail];
        };
    }
    [self PushViewController:svc animated:YES];
}


- (TransportPdtDetail *)coverTransportPdtDetail:(ShopDetail *)shopDetail{
    TransportPdtDetail *billProduct = [[TransportPdtDetail alloc]init];
    billProduct.uuid = shopDetail.uuid;
    billProduct.productUuid = shopDetail.product_uuid;
    billProduct.productCode = shopDetail.product_code;
    billProduct.productName = shopDetail.merchandise;
    billProduct.qpc = [NSNumber numberWithFloat:[shopDetail.packageSpecification floatValue]];
    billProduct.unit = shopDetail.packageUnit;
    billProduct.qty = [NSNumber numberWithFloat:[shopDetail.packageQuantity floatValue]];
    billProduct.packprice = [NSNumber numberWithFloat:[shopDetail.packageUnitPrice floatValue]];
    billProduct.price = [NSNumber numberWithFloat:[shopDetail.foundationUnitPrice floatValue]];
    billProduct.baseQty = [NSNumber numberWithFloat:[shopDetail.foundationQuantity floatValue]];
    billProduct.total = [NSNumber numberWithFloat:[shopDetail.totalMoney floatValue]];
    billProduct.note = shopDetail.remark;
    billProduct.qpcStr = shopDetail.packageQpcStr ? shopDetail.packageQpcStr : @"无" ;
    billProduct.baseUnit = shopDetail.packageQpcUnit;
    
    return billProduct;
}
- (ShopDetail *)coverShopDetail:(TransportPdtDetail *)billProduct{
    ShopDetail *shopDetail = [[ShopDetail alloc]init];
    shopDetail.uuid = billProduct.uuid;
    shopDetail.product_uuid = billProduct.productUuid;
    shopDetail.product_code = billProduct.productCode;
    shopDetail.merchandise  = billProduct.productName;
    shopDetail.packageSpecification  =  [billProduct.qpc stringValue];
    shopDetail.packageUnit = billProduct.unit;
    shopDetail.packageQuantity = [billProduct.qty stringValue];
    shopDetail.packageUnitPrice  = [billProduct.packprice stringValue];
    shopDetail.foundationUnitPrice= [billProduct.price stringValue];
    shopDetail.foundationQuantity= [billProduct.baseQty  stringValue];
    shopDetail.totalMoney= [billProduct.total stringValue];
    shopDetail.remark  = billProduct.note;
    return shopDetail;
    
}
- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex{
    if (buttonIndex == 1) {
        //提交
        [self getDataFromServer:TRANSPORT_STATE_UNRECEIVED msg:@"正在提交..."];
    }
}

#pragma mark - TopPurchaseViewDelegate

- (void)pushNextViewController:(id)vc{
    [self PushViewController:vc animated:YES];
}
#pragma mark - 协议方法
- (void)hiddenKeyBoard{
    [self keyboardHidden];
}
- (void)keyboardHidden{
    [_sheetView.phoneTextFiled resignFirstResponder];
    [_sheetView.carTextFiled resignFirstResponder];
    [_sheetView.remarkTextView resignFirstResponder];
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
