//
//  DataManager.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/12.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "DataManager.h"
#import "FMDatabase.h"
#import "Product.h"
#import "User.h"
@implementation DataManager
{
    FMDatabase *_database;
}
//非标准单例
+ (DataManager *)sharedDatabaseManager{
    static DataManager *manager = nil;
    @synchronized(self){
        if (manager == nil) {
            manager = [[self alloc] init];
        }
    }
    return manager;
}

- (void)createDB
{
    //先获取app.db在沙盒中的路径
    NSString *path = [self getFullDatabasePathFromFileName:@"XFFruit.db"];
    //创建数据库对象
    _database = [[FMDatabase alloc] initWithPath:path];
    //打开数据库
    if ([_database open]) {//第一次打开如果没有那么就创建并打开 如果有直接打开
        //打开成功 那么就创建表
        [self creatTable];
    }else{
        NSLog(@"open database:%@",[_database lastErrorMessage]);
    }
}

#pragma mark - 获取数据库文件的全路径
- (NSString *)getFullDatabasePathFromFileName:(NSString *)name{
    //获取沙盒路径
    NSString *path = NSHomeDirectory();
    NSString *docPath = [path stringByAppendingPathComponent:@"Documents"];
    //要判断Documents存在不存在
    NSFileManager *fm = [NSFileManager defaultManager];
    if ([fm fileExistsAtPath:docPath]) {//存在
        //返回文件在Documents 目录下得路径
        return [docPath stringByAppendingFormat:@"/%@",name];
    }else{
        NSLog(@"Documents不存在");
        //不存在可以自己创建一个Documents目录
        return nil;
    }
}
- (void)creatTable{
    NSArray *arr = @[@"CREATE TABLE IF NOT EXISTS product(serial integer  PRIMARY KEY AUTOINCREMENT,uuid Varchar(1024),code Varchar(1024),secondCode Varchar(1024),name Varchar(1024),qpc Varchar(1024),qpcStr Varchar(1024),measureUnit Varchar(1024),brandName Varchar(1024),manufactory Varchar(1024),isNew Varchar(1024),categoryUuid Varchar(1024),image Varchar(1024),create_time Varchar(1024),create_id Varchar(1024),create_operName Varchar(1024),lastModify_time Varchar(1024),lastModify_id Varchar(1024),lastModify_operName Varchar(1024),enabled Varchar(1024),barcode Varchar(1024),enterprise Varchar(1024),remark Varchar(1024),specification Varchar(1024),version Varchar(1024))",
                     @"CREATE TABLE IF NOT EXISTS user(serial integer  PRIMARY KEY AUTOINCREMENT,uuid Varchar(1024),version Varchar(1024),create_time Varchar(1024),create_id Varchar(1024),create_operName Varchar(1024),lastModify_time Varchar(1024),lastModify_id Varchar(1024),lastModify_operName Varchar(1024),company Varchar(1024),login Varchar(1024),password Varchar(1024),mobile Varchar(1024),email Varchar(1024),enabled Varchar(1024),position Varchar(1024),address Varchar(1024),belongOrg Varchar(1024),remark Varchar(1024))",
                     @"CREATE TABLE IF NOT EXISTS fresh(serial integer  PRIMARY KEY AUTOINCREMENT,id Varchar(1024),title Varchar(1024),url Varchar(1024),time Varchar(1024),desp Varchar(1024))"];
    //遍历数组创建表
    for (NSString *sql in arr) {
        BOOL isSeccess = [_database executeUpdate:sql];
        if (!isSeccess) {
            NSLog(@"create table failed%@",[_database lastErrorMessage]);
        }
    }
}
- (void)insertDataFromModel:(id)model{
    
    Product *product = (Product *)model;
    NSString *sql = @"insert into product (uuid,code,secondCode,name,qpc,qpcStr,measureUnit,brandName,manufactory,isNew,categoryUuid,image,create_time,create_id,create_operName,lastModify_time,lastModify_id,lastModify_operName,enabled,barcode,enterprise,remark,specification,version) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    //？对应的是对象地址类型
    BOOL isSuccess = [_database executeUpdate:sql,product.uuid,product.code,product.secondCode,product.name,product.qpc,product.qpcStr,product.measureUnit,product.brandName,product.manufactory,product.isNew,product.categoryUuid,product.image,product.create_time,product.create_id,product.create_operName,product.lastModify_time,product.lastModify_id,product.lastModify_operName,product.enabled,product.barcode,product.enterprise,product.remark,product.specification,product.version];
    if (!isSuccess) {
        NSLog(@"insert error:%@",[_database lastErrorMessage]);
    }
}

- (void)deleteDataFromProduct{
    NSString *deleteSql = @"delete from product";
    BOOL isSuccess = [_database executeUpdate:deleteSql];
    if (!isSuccess) {
        NSLog(@"delete Error:%@",[_database lastErrorMessage]);
    }
}

- (void)insertDataFromUser:(id)model{
    
    User *user = (User *)model;
    
    
    NSString *sql = @"insert into user (uuid,version,create_time,create_id,create_operName,lastModify_time,lastModify_id,lastModify_operName,company,login,password,mobile,email,enabled,position,address,belongOrg,remark) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    //？对应的是对象地址类型
    BOOL isSuccess = [_database executeUpdate:sql,user.uuid,user.version,user.create_time,user.create_id,user.create_operName,user.lastModify_time,user.lastModify_id,user.lastModify_operName,user.company,user.login,user.password,user.mobile,user.email,user.enabled,user.position,user.address,user.belongOrg,user.remark];
    if (!isSuccess) {
        NSLog(@"insert error:%@",[_database lastErrorMessage]);
    }
}

- (void)deleteDataFromUser{
    NSString *deleteSql = @"delete from user";
    BOOL isSuccess = [_database executeUpdate:deleteSql];
    if (!isSuccess) {
        NSLog(@"delete Error:%@",[_database lastErrorMessage]);
    }
}



@end
