//
//  JTOptionsEntity.m
//  JobTalk
//
//  Created by Xummer on 14-5-22.
//  Copyright (c) 2014年 BST. All rights reserved.
//

#import "JTOptionsEntity.h"
#define OPTION_ENTITY_KEY   @"name"
#define OPTION_ENTITY_LOCAL_KEY @"login"

@interface JTOptionsEntity ()
@end

@implementation JTOptionsEntity

+ (NSString *)lowcaseAndDeleteWhitespace:(NSString *)str {
    return [[str lowercaseString] stringByReplacingOccurrencesOfString:@" " withString:@""];
}

+ (NSInteger)indexOfOptionStr:(NSString *)option inOptions:(NSArray *)options {
    return [options indexOfObjectPassingTest:^BOOL(id obj, NSUInteger idx, BOOL *stop) {
//        NSString *tmpObj = [[self class] lowcaseAndDeleteWhitespace:obj];
//        NSString *tmpOpt = [[self class] lowcaseAndDeleteWhitespace:option];
        
        if ([obj isEqualToString:option]) {
            return YES;
        }
        else {
            return NO;
        }
    }];
}

+ (JTOptionsEntity *)entityWithOptions:(NSArray *)options andSelectedIndex:(NSInteger)sIndex {
    return [[self alloc] initWithOptions:options andSelectedIndex:sIndex];
}

+ (JTOptionsEntity *)entityWithOptions:(NSArray *)options
                    defaultOptionIndex:(NSInteger)dIndex
                     andSelectedOption:(NSString *)option
{
    if (dIndex < 0 || dIndex >= [options count]) {
        dIndex = 0;
    }
    
    NSArray *arrDis = nil;
    if ([[options firstObject] isKindOfClass:[NSString class]]) {
        arrDis = options;
    }
    else {
        arrDis = [options valueForKeyPath:OPTION_ENTITY_LOCAL_KEY];
    }
    
    NSInteger sInd = [[self class] indexOfOptionStr:option inOptions:arrDis];
    sInd = sInd == NSNotFound ? dIndex : sInd;
    
    return [[self class] entityWithOptions:options andSelectedIndex:sInd];
}

+ (JTOptionsEntity *)entityWithOptions:(NSArray *)options andSelectedOption:(NSString *)option {
    NSArray *arrDis = nil;
    if ([[options firstObject] isKindOfClass:[NSString class]]) {
        arrDis = options;
    }
    else {
        arrDis = [options valueForKeyPath:OPTION_ENTITY_LOCAL_KEY];
    }
    NSInteger sInd = [[self class] indexOfOptionStr:option inOptions:arrDis];
    sInd = sInd == NSNotFound ? 0 : sInd;
    
    return [[self class] entityWithOptions:options andSelectedIndex:sInd];
}

- (id)initWithOptions:(NSArray *)options andSelectedIndex:(NSInteger)sIndex {
    self = [super init];
    if (!self) {
        return nil;
    }
    
    self.optionsArray = options;
    if ([[options firstObject] isKindOfClass:[NSString class]]) {
        self.m_arrDisplayStr = options;
    }
    else {
        self.m_arrDisplayStr = [options valueForKeyPath:OPTION_ENTITY_LOCAL_KEY];
    }
    
    if (sIndex >= 0 && sIndex < [options count]) {
        self.selectedIndex = sIndex;
    }
    
    return self;
}

- (id)getSelectedOption {
    if (_selectedIndex >= 0 && _selectedIndex < [_optionsArray count]) {
        return _optionsArray[ _selectedIndex ];
    }
    else {
        return _defaultOption;
    }
}

- (id)getSelectedOptionForCommit {
    return [[self class] lowcaseAndDeleteWhitespace:[self getSelectedOption]];
}

- (NSInteger)indexOfOptionStr:(NSString *)option {
    return [[self class] indexOfOptionStr:option inOptions:_m_arrDisplayStr];
}

@end
