//
//  ICRUserUtil.h
//  XFFruit
//
//  Created by Xummer on 3/29/15.
//  Copyright (c) 2015 Xummer. All rights reserved.
//

#import "IBTObject.h"

@interface ICRUserUtil : IBTObject <NSCoding, NSCopying>

// Login Data
@property (copy, nonatomic) NSString *userName;
@property (copy, nonatomic) NSString *password;
@property (copy, nonatomic) NSString *registerCode;
@property (copy, nonatomic) NSString *token;
@property (copy, nonatomic) NSNumber *bAutoLogin;
@property (copy, nonatomic) NSString *authenticode;

// User Data
@property (copy, nonatomic) NSString *displayName;
@property (copy, nonatomic) NSString *userCode;
@property (copy, nonatomic) NSString *orgCode;
@property (copy, nonatomic) NSString *orgName;
@property (copy, nonatomic) NSString *userId;
@property (copy, nonatomic) NSString *orgId;
@property (copy, nonatomic) NSString *currentStoreID;
@property (copy, nonatomic) NSString *uniqueID;

+ (instancetype)sharedInstance;

- (BOOL)saveArchive;

- (BOOL)isLogin;

- (void)logout;

- (NSString *)mobileID;

- (void)storageUserName:(NSString *)userName
               password:(NSString *)password
           registerCode:(NSString *)registerCode
                  token:(NSString *)token;

- (void)storageCurrentStoreID:(NSString *)currentStoreID;

- (void)updatePassword:(NSString *)pwd;

@end
