//
//  BusinessViewController.m
//  XFFruit
//
//  Created by mac on 15/8/13.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "BusinessViewController.h"

#import "ICRTaskListViewController.h"
#import "ICRPatrolPlanViewController.h"
#import "ICRStoreListViewController.h"
#import "ICRStoreDetailViewController.h"
#import "ICRAnnouncementViewController.h"

#import "NewSurveyViewController.h"
#import "SurveyViewController.h"
#import "AddWorkSheetViewController.h"

#import "ICRFunctionBaseView.h"
#import "ICRFunctionEntity.h"
#import "ICRFunctionBaseView.h"

#import "NewPurchaseNoticeViewController.h"
#import "SeePurchaseNoticeViewController.h"

@interface BusinessViewController ()<ICRFunctionBaseViewDelegate>

@end

@implementation BusinessViewController

- (void)viewDidLoad {
    [super viewDidLoad];
//    [self initView];
    [self setupSubviews];
    // Do any additional setup after loading the view.
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
-(void)setupSubviews
{
    NSMutableArray *arrFunctionEntities = [NSMutableArray array];
    
    NSArray *functionImageNames = @[ @"AnnouncementIcon",@"create_surver",@"watch_surver",@"create_surver_result",@"create_needs",@"watch_needs",@"create_purchase",@"watch_purchase",@"review_purchase",@"create_transport",@"watch_transort",@"create_process"];
    NSArray *fuctionNames = @[ [IBTCommon localizableString:@"Announcement"],
                               [IBTCommon localizableString:@"AddSurvey"],
                               [IBTCommon localizableString:@"Survey"],
                               [IBTCommon localizableString:@"Survey1"],
                               [IBTCommon localizableString:@"Survey2"],
                               [IBTCommon localizableString:@"Survey3"],
                               [IBTCommon localizableString:@"Survey4"],
                               [IBTCommon localizableString:@"Survey5"],
                               [IBTCommon localizableString:@"Survey6"],
                               [IBTCommon localizableString:@"Survey7"],
                               [IBTCommon localizableString:@"Survey8"],[IBTCommon localizableString:@"Survey9"],
                               ];
    NSArray *functionTags = @[ @(kFunctionNotice),
                               //公告
                               @(kFunctionNewSurvey),
                               //新建行情调研
                               @(kFunctionSeeSurvey),
                               //查看行情调研
                               @(kFunctionFeeBackSurvey),
                               //填写行情反馈
                               @(kFunctionNewPurchaseNotice),
                               //新建采购通知
                               @(kFunctionSeePurchaseNotice),
                               //查看采购通知
                               @(kFunctionNewPurchase),
                               //新建采购单
                               @(kFunctionSeePurchase),
                               //查看采购单
                               @(kFunctionExaminePurchas),
                               //审核采购单
                               @(kFunctionNewShipment),
                               //新建发运单
                               @(kFunctionSeeShipment),
                               //查看发运单
                               @(kFunctionNewProcessing)];
                               //新建加工单
    
    int i = 0;
    for (NSString *functionName in fuctionNames) {
        ICRFunctionEntity *funtionEntity = [[ICRFunctionEntity alloc] init];
        funtionEntity.functionName = functionName;
        funtionEntity.iconName = [functionImageNames objectAtIndex:i];
        funtionEntity.functionItemTag = [[functionTags objectAtIndex:i] integerValue];
        [arrFunctionEntities addObject:funtionEntity];
        i ++;
    }
    
    ICRFunctionBaseView *baseView = [ICRFunctionBaseView initWithFunctionData:arrFunctionEntities];
    
    baseView.frame = (CGRect){
        .origin.x = 0,
        .origin.y =0,
        .size.width = CGRectGetWidth(self.view.frame),
        .size.height = CGRectGetHeight(self.view.frame),};
    baseView.backgroundColor = [UIColor clearColor];
    baseView.m_delegate = self;
    [self.view addSubview:baseView];

}

#pragma mark - ICRFunctionBaseViewDelegate
- (void)ICRFunctionBaseView:(ICRFunctionItemControl *)imageView {
    /*
     kFunctionAnnouncement = 0,
     kFunctionTaskManagement,
     kFunctionPatrolPlan,
     kFunctionMyShop,
     */
    switch (imageView.tag) {
        case kFunctionNotice://公告
        {
            ICRAnnouncementViewController *aVC = [[ICRAnnouncementViewController alloc] init];
            [self PushViewController:aVC animated:YES];
        }
            break;
        case kFunctionNewSurvey://新建行情
        {
            NewSurveyViewController *svc = [[NewSurveyViewController alloc] init];
            svc.title = [IBTCommon localizableString:@"AddSurvey"];
            [self PushViewController:svc animated:YES];
        }
            break;
        case kFunctionSeeSurvey://查看行情
        {
            SurveyViewController *svc = [[SurveyViewController alloc] init];
            svc.title = [IBTCommon localizableString:@"Survey"];
            [self PushViewController:svc animated:YES];
        }
            break;
        case kFunctionNewPurchaseNotice://新建采购通知单
        {
            NewPurchaseNoticeViewController *svc = [[NewPurchaseNoticeViewController alloc] init];
            svc.title = [IBTCommon localizableString:@"Survey2"];
            [self PushViewController:svc animated:YES];
        }
            break;
        case kFunctionSeePurchaseNotice://查看采购通知单
        {
            SeePurchaseNoticeViewController *svc =
            [[SeePurchaseNoticeViewController alloc] init];
            svc.title = [IBTCommon localizableString:@"Survey3"];
            [self PushViewController:svc animated:YES];
        }
            break;
       
        case kFunctionTaskManagement://任务管理
        {
            ICRTaskListViewController *tVC = [[ICRTaskListViewController alloc] init];
            [self PushViewController:tVC animated:YES];
        }
            break;
        case kFunctionPatrolPlan://巡店计划
        {
            ICRPatrolPlanViewController *pVC = [[ICRPatrolPlanViewController alloc] initWithStore:nil isHomeShow:YES];
            [self PushViewController:pVC animated:YES];
        }
            break;
        case kFunctionMyShop://我的店铺
        {
            //            ICRStoreListViewController *sVC = [[ICRStoreListViewController alloc] initWithBHaveToChooseOne:NO];
            //            sVC.title = [IBTCommon localizableString:@"MyStore"];
            //            sVC.m_delegate = self;
            //            [self PushViewController:sVC animated:YES];
            AddWorkSheetViewController *sVC = [[AddWorkSheetViewController alloc] init];
            [self PushViewController:sVC animated:YES];
        }
            break;

        default:
            return;
            break;
    }
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/
-(void)initView
{
    NSArray *butArray=[[NSArray alloc]initWithObjects:@"公告", @"新建行情调研",@"查看行情调研",@"填写行情反馈",@"新建采购通知",@"查看采购通知",@"新建采购单",@"查看采购单",@"审核采购单",@"新建发运单",@"查看发运单",@"新建加工单",nil];
    for (int i=0; i<butArray.count; i++) {
        UIButton *but=[UIButton buttonWithType:UIButtonTypeCustom];
        but.frame=CGRectMake(15+i%3*(90+10),10+(i/3)*(100+10) , 90, 90) ;
        //        but.titleLabel.text=[NSString stringWithFormat:@"%@",[butArray objectAtIndex:i]];
        NSString *str=[butArray objectAtIndex:i];
        [but setTitle:str forState:UIControlStateNormal];
        but.backgroundColor=[UIColor redColor];
        [self .view addSubview:but];
        
    }
    
}

@end
