//
//  NewPurchaseNoticeViewController.m
//  XFFruit
//
//  Created by mac on 15/8/16.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "NewPurchaseNoticeViewController.h"

#import "SurveyCell.h"
#import "HPGrowingTextView.h"

#import "ChosePersonViewController.h"
#import "SurveyUser.h"
#import "Survey.h"
#import "PurchaseNoticeCell.h"




#define LeftMargin 15
#define BtnHeight 44
#define TableHeight 46
#define CornerRadius 5
#define TitleSize 15
#define BtnSize 19
#define TotalHeight 432
#define KeyboardHeight 258
#define DateViewHeight 300
@interface NewPurchaseNoticeViewController()<UITableViewDataSource,UITableViewDelegate,UITextFieldDelegate,HPGrowingTextViewDelegate>
{
    UITableView *_tableView;
    NSMutableArray *_dataArr;
    UITextField *_titleField;
    UILabel *_productLabel;
    UILabel *_startDateLabel;
    UILabel *_endDateLabel;
    UILabel *_personLabel;
    HPGrowingTextView *_noteTextView;
    
    BOOL _isClickStart;
    
    
    
    
    UITableView *mingXiTableView;
   

}
@property (nonatomic,strong)NSString *titleStr;
@property (nonatomic,strong)NSString *productCodeStr;
@property (nonatomic,strong)NSString *productNameStr;
@property (nonatomic,strong)NSString *productUuidStr;
@property (nonatomic,strong)NSString *beginDateStr;
@property (nonatomic,strong)NSString *endDateStr;
@property (nonatomic,strong)NSString *remarkStr;
@property (nonatomic,strong)NSMutableArray *users;
@property (nonatomic,strong)Survey *survey;


@end

@implementation NewPurchaseNoticeViewController

- (void)viewDidLoad {
    [super viewDidLoad];
     [self setupSubviews];
    // Do any additional setup after loading the view.
}
-(void)setupSubviews
{
    _dataArr=[[NSMutableArray alloc]initWithObjects:@"标题：",@"采购员：",@"备注：", nil];
    self.view.backgroundColor  = XXFBgColor;
    
    _tableView = [[UITableView alloc]initWithFrame:(CGRectMake(0, LeftMargin,ScreenSize.width, ScreenSize.height/2 - 64 - LeftMargin)) style:(UITableViewStylePlain)];
    _tableView.backgroundColor = [UIColor whiteColor];
    _tableView.tag=1001;
    _tableView.bounces = NO;
    _tableView.delegate = self;
    _tableView.dataSource = self;
    
    
    UIView *footView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 50)];
    [self.view addSubview:footView];
    _tableView.tableFooterView = footView;
    [self.view addSubview:_tableView];
    
    
    
    
    mingXiTableView=[[UITableView alloc]initWithFrame:CGRectMake(0, 2*LeftMargin+_tableView.frame.size.height, ScreenSize.width, ScreenSize.height-_tableView.height-64-LeftMargin)];
     mingXiTableView.backgroundColor = [UIColor whiteColor];
    mingXiTableView.tag=1002;
    mingXiTableView.bounces=YES;
    mingXiTableView.delegate=self;
    mingXiTableView.dataSource=self;
    
    UIView *footView2 = [[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 50)];
    footView2.backgroundColor=[UIColor whiteColor];
    UIButton *button=[UIButton  buttonWithType: UIButtonTypeCustom];
    [button  setFrame:CGRectMake(50, 5, 200, 30)];
    [button setTitle:@"点击添加商品行情" forState:UIControlStateNormal];
    [button setTitleColor:[UIColor grayColor] forState:UIControlStateNormal];
//    button.alpha=0;
    [footView2 addSubview:button];
    UIView *footView3=[[UIView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 50)];
    footView3.backgroundColor=[UIColor whiteColor];
    UILabel *lable=[[UILabel alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, 50)];
    lable.text=@"     商品  价格  包装规格   包装数量";
    [footView3 addSubview:lable];
    
    [self.view addSubview:footView2];
    [self.view addSubview:footView3];
    mingXiTableView.tableFooterView = footView2;
    mingXiTableView.tableHeaderView=footView3;
    [self.view addSubview:mingXiTableView];
//    for (int i=0; i<3; i++) {
//        UILabel *lable=[[UILabel alloc]initWithFrame:CGRectMake(10, 10+i*(30+30), 80, 30)];
//        lable.font=FontSize(17);
//        [lable setText:[array objectAtIndex:i]];
//        [lable setTextColor:[UIColor blueColor] ];
//        [self.view  addSubview:lable];
//    }
}

#pragma mark - 协议方法
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    if ([tableView isEqual:_tableView]) {
        return 1;
    }else if ([tableView isEqual:mingXiTableView])
    {
      return 1;
    }
    
    return 1;
}
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    if ([tableView isEqual:_tableView]) {
         return _dataArr.count;
    }else if ([tableView isEqual:mingXiTableView])
    {
       return _dataArr.count;
    }
    return 1;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    if ([tableView isEqual:_tableView]) {
   
    static NSString *cellID = @"cellID";
    SurveyCell *cell = [tableView dequeueReusableCellWithIdentifier:cellID];
    if (cell == nil) {
        cell = [[SurveyCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellID];
        tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        if (indexPath.row >0 && indexPath.row < _dataArr.count - 1) {
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
        [self createViewInCell:cell indexPath:indexPath];
    }
    [cell setTitleStr:_dataArr[indexPath.row]];
    return cell;
    }else if ([tableView isEqual:mingXiTableView])
    {
        
        static NSString *CellID = @"CellID";
        PurchaseNoticeCell *Cell = [tableView dequeueReusableCellWithIdentifier:CellID];
        if (Cell == nil) {
            Cell = [[PurchaseNoticeCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellID];
            tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
            Cell.selectionStyle = UITableViewCellSelectionStyleNone;
//            if (indexPath.row >0 && indexPath.row < _dataArr.count - 1) {
//                cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
//            }
//            [self createViewInCell:cell indexPath:indexPath];
        }
//        [cell setTitleStr:_dataArr[indexPath.row]];
        return Cell;

    }
    return nil;
}
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath{
    if ([tableView isEqual:_tableView]) {
        if (indexPath.row == 2){
            return TableHeight*2;
        }else{
            return TableHeight;
        }
        
    }else if ([tableView isEqual:mingXiTableView])
    {
        return TableHeight;
    }
    return TableHeight;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath{
    if ([tableView isEqual:_tableView]) {
   
    if (indexPath.row == 2 || indexPath.row == 3) {
        [self keyboardHidden];
        if (indexPath.row == 2) {
            _isClickStart = YES;
        }else{
            _isClickStart = NO;
        }
        
    }else if(indexPath.row == 1){
        ChosePersonViewController *cvc = [ChosePersonViewController new];
        cvc.chosePerson = ^(NSArray *users){
            NSString *textStr = @"";
            if (self.users.count <=0) {
                [self.users removeAllObjects];
            }
            for (SurveyUser *user in users) {
                if (textStr.length == 0) {
                    textStr = [textStr stringByAppendingFormat:@"%@",user.userName];
                }else {
                    textStr = [textStr stringByAppendingFormat:@"、%@",user.userName];
                }
                [self.users addObject:[user dictForCommit]];
            }
            _personLabel.text = textStr;
            _personLabel.textColor = HexColor(@"444444");
            
        };
        cvc.isMoreChose = NO;
        [self PushViewController:cvc animated:YES];
    }
    }
}


-  (void)createViewInCell:(SurveyCell *)cell indexPath:(NSIndexPath *)indexPath{
    if (indexPath.row == 0) {
        _titleField = [[UITextField alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight)];
        _titleField.textAlignment = NSTextAlignmentRight;
        _titleField.textColor = HexColor(@"444444");
        _titleField.placeholder = @"输入采购通知标题";
        _titleField.font = FontSize(15);
        _titleField.returnKeyType = UIReturnKeyDone;
        _titleField.delegate = self;
        [cell.contentView addSubview:_titleField];
//        if (self.survey) {
//            _titleField.text = [IBTCommon checkString:self.survey.title];
//            self.titleStr = [IBTCommon checkString:self.survey.title];
//        }
//    }else
    }else if (indexPath.row == _dataArr.count -1){
        _noteTextView = [[HPGrowingTextView alloc] initWithFrame:CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight)];
        _noteTextView.contentInset = UIEdgeInsetsMake(5, 5, 5, 0);
        _noteTextView.minNumberOfLines = 1;
        _noteTextView.maxNumberOfLines = 4;
        _noteTextView.font = FontSize(15);
        _noteTextView.textAlignment = NSTextAlignmentRight;
        _noteTextView.delegate = self;
        _noteTextView.returnKeyType = UIReturnKeyDone;
        _noteTextView.placeholder = @"输入备注内容";
        [cell.contentView addSubview:_noteTextView];
//        if (self.survey) {
//            _noteTextView.text =  [IBTCommon checkString:self.survey.remark];
//            self.remarkStr = [IBTCommon checkString:self.survey.remark];
//        }
        CGRect lineFrame =  cell.lineLabel.frame;
        lineFrame.origin.y = TableHeight*2-1;
        cell.lineLabel.frame = lineFrame;
    }else{
        UILabel *contentLabel = [[UILabel alloc]initWithFrame:(CGRectMake(100+LeftMargin, 0, ScreenSize.width - 100 - LeftMargin*2-10, TableHeight))];
        contentLabel.textAlignment= NSTextAlignmentRight;
        contentLabel.textColor = HexColor(@"bbbbbb");
        contentLabel.font = FontSize(TitleSize);
        [cell.contentView addSubview:contentLabel];
        if (indexPath.row == 1) {
            contentLabel.text = @"选择采购员";
            _personLabel = contentLabel;
            [self preferDataInPersonLabel];
        }
    }
    }

- (void)preferDataInPersonLabel{
    if (self.survey) {
        if (self.survey.users.count > 0) {
            NSString *personStr = @"";
            for (SurveyUser * surveyUser in self.survey.users) {
                if (personStr.length == 0) {
                    personStr = [personStr stringByAppendingFormat:@"%@",surveyUser.userName];
                }else {
                    personStr = [personStr stringByAppendingFormat:@"、%@",surveyUser.userName];
                }
            }
            _personLabel.text = personStr;
            _personLabel.textColor = HexColor(@"444444");
            
        }
        if (self.users > 0) {
            [self.users addObjectsFromArray:self.survey.users];
        }
    }
}

#pragma mark delegate
- (BOOL)growingTextViewShouldReturn:(HPGrowingTextView *)growingTextView{
    [_noteTextView resignFirstResponder];
    [self setTableFrame:LeftMargin];
    return YES;
}
- (void)growingTextViewDidBeginEditing:(HPGrowingTextView *)growingTextView{
    CGFloat offset = ScreenSize.height - TotalHeight - KeyboardHeight;
    if (offset < 0) {//上移
        [self setTableFrame:LeftMargin+offset];
    }
}
- (void)setTableFrame:(CGFloat)tabelH{
    [UIView animateWithDuration:0.25 animations:^{
        CGRect tableFrame = _tableView.frame;
        tableFrame.origin.y = tabelH;
        _tableView.frame = tableFrame;
    }];
}

- (void)keyboardHidden{
    [_titleField resignFirstResponder];
    [_noteTextView resignFirstResponder];
    [self setTableFrame:LeftMargin];
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
