//
//  AddWorkSheetViewController.m
//  XFFruit
//
//  Created by 陈俊俊 on 15/8/12.
//  Copyright (c) 2015年 Xummer. All rights reserved.
//

#import "AddWorkSheetViewController.h"
#import "TopSheetView.h"

#define TopHeight 284
#define BottomHeight 300
#define SpaceHeight 20
#define ContentHeight 44
#define BeginTag 7000
#define SpaceWidth 20
#define BtnWidth (ScreenSize.width - 20*4)/3
@interface AddWorkSheetViewController ()<TopSheetViewDelegate,UIScrollViewDelegate>
{
    UIScrollView *_scrollView;
    TopSheetView *_sheetView;
    UIView *_bottomView;
    UIScrollView *_bottomSV;
    UIImageView *_moveImageView;
}
@end

@implementation AddWorkSheetViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    //布局
    [self bulidLayout];
}
- (void)bulidLayout{
    self.view.backgroundColor  = XXFBgColor;
    _scrollView = [[UIScrollView alloc]initWithFrame:CGRectMake(0,0, ScreenSize.width, ScreenSize.height- 64)];
    _scrollView.showsHorizontalScrollIndicator  = NO;
    _scrollView.showsVerticalScrollIndicator = NO;
    _scrollView.contentSize = CGSizeMake(ScreenSize.width, TopHeight+ BottomHeight + SpaceHeight*2);
    [self.view addSubview:_scrollView];
    
    _sheetView = [[TopSheetView alloc]initWithFrame:CGRectMake(0, 0, ScreenSize.width, TopHeight)];
    _sheetView.delegate = self;
    [_scrollView addSubview:_sheetView];
    
    _bottomView = [[UIView alloc]initWithFrame:CGRectMake(0, CGRectGetMaxY(_sheetView.frame) + 20, ScreenSize.width,BottomHeight)];
    _bottomView.backgroundColor = [UIColor whiteColor];
    [_scrollView addSubview:_bottomView];
    [self createBottomView];
}
- (void)createBottomView{
    NSArray *arr = @[@"原料明细",@"成品明细",@"费用明细"];

    _bottomSV = [[UIScrollView alloc]initWithFrame:CGRectMake(0,ContentHeight + 4, ScreenSize.width, CGRectGetHeight(_bottomView.frame) - ContentHeight-2 )];
    _bottomSV.showsHorizontalScrollIndicator  = NO;
    _bottomSV.showsVerticalScrollIndicator = NO;
    _bottomSV.pagingEnabled = YES;
    _bottomSV.delegate = self;
    _bottomSV.backgroundColor = [UIColor yellowColor];
    _bottomSV.contentSize = CGSizeMake(ScreenSize.width * arr.count, CGRectGetHeight(_bottomSV.frame));
    [_bottomView addSubview:_bottomSV];
    
    for (NSInteger i = 0; i < arr.count; i++) {
        UIButton *btn = [UIButton buttonWithType:UIButtonTypeSystem];
        [btn setTitle:arr[i] forState:UIControlStateNormal];
        btn.frame = CGRectMake(SpaceWidth + (BtnWidth+SpaceWidth) * i, 0, BtnWidth, ContentHeight);
        [btn setTitleColor:HexColor(@"444444") forState:UIControlStateNormal];
        btn.titleLabel.font = FontSize(16);
        btn.tag = i + BeginTag;
        [btn addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
        [_bottomView addSubview:btn];
        
        UIView *image = [[UIView alloc]initWithFrame:CGRectMake(CGRectGetWidth(_bottomSV.frame) * i, 0, CGRectGetWidth(_bottomSV.frame), CGRectGetHeight(_bottomSV.frame))];
        if (i == 0) {
            image.backgroundColor = [UIColor redColor];
        }else if(i == 1){
            image.backgroundColor = [UIColor blackColor];
        }else if(i == 2){
            image.backgroundColor = [UIColor blueColor];
        }
        [_bottomSV addSubview:image];
    }
    _moveImageView = [[UIImageView alloc]initWithFrame:CGRectMake(SpaceWidth, ContentHeight, BtnWidth,4)];
    _moveImageView.image  = [UIImage imageNamed:@"tab_line"];
    [_bottomView addSubview:_moveImageView];
}



- (void)btnClick:(UIButton *)btn{
    NSInteger index = btn.tag - BeginTag;
    [UIView animateWithDuration:0.5 animations:^{
        CGRect moveFrame = _moveImageView.frame;
        moveFrame.origin.x = SpaceWidth + (BtnWidth+SpaceWidth) * index;
        _moveImageView.frame = moveFrame;
    }];
}

- (void)scrollViewDidEndDecelerating:(UIScrollView *)scrollView{
    if (scrollView == _bottomSV) {
//        CGFloat index = _bottomSV.contentOffset.x / _bottomSV.frame.size.width;
        
    }
}



#pragma mark - 协议方法
- (void)hiddenKeyBoard{
    [self keyboardHidden];
}
- (void)keyboardHidden{
    [_sheetView.titleTextFiled resignFirstResponder];
    [_sheetView.peopleTextFiled resignFirstResponder];
    [_sheetView.peopleTextFiled resignFirstResponder];
    [_sheetView.phoneTextFiled resignFirstResponder];
    [_sheetView.remarkTextView resignFirstResponder];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
