import { fileURLToPath, URL } from 'node:url'

import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import AutoImport from 'unplugin-auto-import/vite'
import Components from 'unplugin-vue-components/vite'
import { ElementPlusResolver } from 'unplugin-vue-components/resolvers'


// https://vitejs.dev/config/
export default defineConfig({
  plugins: [
    vue(),
    AutoImport({
      resolvers: [ElementPlusResolver()]
    }),
    Components({
      resolvers: [ElementPlusResolver()]
    })
  ],
  base: './',
  resolve: {
    alias: {
      '@': fileURLToPath(new URL('./src', import.meta.url))
    }
  },
  server: {
    proxy: {
      '/api/': {
        target: 'http://127.0.0.1:5000/', // 本机后端服务
        // target: 'http://wm-tools-backend.frp.wmdigit.com:8888/', // new3090后端服务
        // target: 'http://wm-tools-backend-test.frp.wmdigit.com:8888/', // 测试后端服务
        changeOrigin: true,
        rewrite: (path: any) => path.replace(/^\/api/, '')
      }
    },
    host: '0.0.0.0',
    port: 9529,
    https: false,
  }
})
