import { ref } from 'vue'
import {
  ElMessage,
  genFileId,
  type UploadInstance,
  type UploadProps,
  type UploadRawFile,
  type UploadFile,
} from 'element-plus'


  export const myFileUpload = (FileSizeLimitM: number, form: any, loading: any) => {
  // ############  处理上传文件 begin #############
  const upload = ref<UploadInstance>()
  const actionUrl = ref(
    import.meta.env.MODE === 'production'
      ? '/file'
      : import.meta.env.VITE_APP_BASE_API + '/file'
  )
  const handleBeforeUpload = async (file: any) => {
    const isLimit = file.size / 1024 / 1024 <= FileSizeLimitM
    if (!isLimit) {
      ElMessage.error('上传文件大小不能超过 '+FileSizeLimitM+'MB!')
      return false
    }
  }
  const handleUploadSuccess = (val: Wm.UploadResult, file: UploadFile) => {
    // console.log(val)
    if (val.code == 0) {
      form.file_path = val.data[0].path
      console.log('form.file_path =', form.file_path)
      form.file_path_domain = val.data[0].url
      console.log('form.file_path_domain =', form.file_path_domain)
      // console.log('file =', file.name, file.size, file.url)
      if (file.name && file.size !== undefined) {
        form.file_name = file.name
        form.file_size = file.size
      }
      ElMessage({
        message: '上传成功',
        type: 'success'
      })
    } else {
      ElMessage({
        message: '上传失败：' + val.message,
        type: 'error'
      })
    }
    loading.value = false
  }
  const handleUploadExceed: UploadProps['onExceed'] = (files) => {
    // 清除已上传的文件
    upload.value!.clearFiles()
    // 获取超出限制的第一个文件
    const file = files[0] as UploadRawFile
    // 给文件分配一个新的唯一标识
    file.uid = genFileId()
    // 手动触发文件上传
    upload.value!.handleStart(file)
    // 提交上传
    upload.value!.submit()
  }
  const handleUploadError = (error: Error) => {
    ElMessage({
      message: String(error.message),
      type: 'error'
    })
    loading.value = false
  }
  const handleUploadProgress = (event: ProgressEvent, file: UploadFile) => {
    file.percentage = Math.round(event.loaded / event.total * 100)
    console.log('上传进度：', file.percentage)
    form.file_uploading_progress = file.percentage
    file.url = '/video-icon.png'
    // 根据进度控制 loading 状态
    if (file.percentage <= 100) {
      loading.value = true
    }
    // if (file.percentage == 100) {
    //   loading.value = false
    // }
  }
  const handleRemoveFile = () => {
    // 清除已上传的文件
    // upload.value!.clearFiles()
    form.file_path = ""
    form.file_path_domain = ""
    form.file_name = ""
    form.file_size = 0
    console.log('文件列表移除File, form.file_path =', form.file_path, ', form.file_path_domain =', form.file_path_domain)
  }

  // ############  处理上传文件 end #############

  return {
    loading,
    upload,
    actionUrl,
    handleBeforeUpload,
    handleUploadSuccess,
    handleUploadExceed,
    handleUploadError,
    handleUploadProgress,
    handleRemoveFile,
  }
}
