import aitoolsService from '@/api/service/aitoolsService';
declare var wx: any;

 
// 初始化微信JS-SDK
export const myWechatSDK = () => {
  const initWechatSDK = () => {
    // 确保 wx 对象存在
    if (typeof wx !== 'undefined') {
      // 获取当前URL，不包含#及其后面的部分
      var currentUrl = window.location.href.split('#')[0];
      // 调用后端接口获取微信配置
      aitoolsService.commonApi('提交用户轨迹数据', 'fetch_wx_config', {current_url: currentUrl}).then(config => {
        // console.log('config:', config);
        if (!config || !config.appId || !config.timestamp || !config.nonceStr || !config.signature) {
          console.error('获取微信配置失败:', config);
          return;
        }
        wx.config({
          debug: false,
          appId: config.appId, // 从后端获取的 appId
          timestamp: config.timestamp, // 从后端获取的时间戳
          nonceStr: config.nonceStr, // 从后端获取的随机字符串
          signature: config.signature, // 从后端获取的签名
          jsApiList: ['updateAppMessageShareData', 'updateTimelineShareData','onMenuShareTimeline','onMenuShareAppMessage'] // 需要使用的微信 API
        });
        wx.ready(() => {
          // 分享到朋友圈
          const shareData = {
            title: '元芒数字-运营数据分析',
            link: currentUrl, // 当前页面链接
            imgUrl: 'https://mmecoa.qpic.cn/sz_mmecoa_jpg/icJ3dTLKWY5Wo8W283kdW4QhHbFFLRCqb6TwsnkCWC6LXs8DuVEicyaib980gGKkVjU4SVO8UWS8DhMiaXur0YAD8w/640?wx_fmt=jpeg', // 分享图标
            desc: '全面的运营数据分析，一键生成报告，助力决策！📈',
            success: () => {
              console.log('分享设置成功');
            }
          };
          // 设置分享给朋友
          wx.updateAppMessageShareData(shareData);
          // 设置分享至朋友圈
          wx.updateTimelineShareData(shareData);
          // 分享到朋友圈
          wx.onMenuShareTimeline(shareData);
          // 分享到朋友
          wx.onMenuShareAppMessage(shareData);
        });
        wx.error((error: any) => {
          console.error('微信配置错误:', error);
        });
      });
    } else {
      console.error('wx 对象未定义');
    }
  }

  return {
    initWechatSDK,
    wx,
  }

}
