import { ref } from 'vue'
import {
  ElMessage,
  genFileId,
  type UploadInstance,
  type UploadProps,
  type UploadRawFile,
  type UploadFile,
  type UploadFiles,
} from 'element-plus'


  export const myFileUpload = (FileSizeLimitM: number, form: any, loading: any, fileList: any) => {
  // ############  处理上传文件 begin #############
  const upload = ref<UploadInstance>()
  const actionUrl = ref(
    import.meta.env.MODE === 'production'
      ? '/file'
      : import.meta.env.VITE_APP_BASE_API + '/file'
  )
  const handleBeforeUpload = async (file: any) => {
    const isLimit = file.size / 1024 / 1024 <= FileSizeLimitM
    if (!isLimit) {
      ElMessage.error('上传文件大小不能超过 '+FileSizeLimitM+'MB!')
      return false
    }
  }
  const handleUploadSuccess = (val: Wm.UploadResult, file: UploadFile) => {
    // console.log(val)
    if (val.code == 0) {
      form.file_path = val.data[0].path
      console.log('form.file_path =', form.file_path)
      form.file_path_domain = val.data[0].url
      console.log('form.file_path_domain =', form.file_path_domain)
      // console.log('file =', file.name, file.size, file.url)
      if (file.name && file.size !== undefined) {
        form.file_name = file.name
        form.file_size = file.size
      }
      ElMessage({
        message: '上传成功',
        type: 'success'
      })
    } else {
      ElMessage({
        message: '上传失败：' + val.message,
        type: 'error'
      })
    }
    loading.value = false
  }
  const handleUploadExceed: UploadProps['onExceed'] = (files) => {
    // 清除已上传的文件
    upload.value!.clearFiles()
    // 获取超出限制的第一个文件
    const file = files[0] as UploadRawFile
    // 给文件分配一个新的唯一标识
    file.uid = genFileId()
    // 手动触发文件上传
    upload.value!.handleStart(file)
    // 提交上传
    upload.value!.submit()
  }
  const handleUploadError = (error: Error) => {
    ElMessage({
      message: String(error.message),
      type: 'error'
    })
    loading.value = false
  }
  const handleUploadProgress = (event: ProgressEvent, file: UploadFile) => {
    file.percentage = Math.round(event.loaded / event.total * 100)
    console.log('上传进度：', file.percentage)
    file.url = '/video-icon.png'
    // 根据进度控制 loading 状态
    if (file.percentage <= 100) {
      loading.value = true
    }
    // if (file.percentage == 100) {
    //   loading.value = false
    // }
  }
  const handleRemoveFile = () => {
    // 清除已上传的文件
    // upload.value!.clearFiles()
    form.file_path = ""
    form.file_path_domain = ""
    form.file_name = ""
    form.file_size = 0
    console.log('文件列表移除File, form.file_path =', form.file_path, ', form.file_path_domain =', form.file_path_domain)
  }

  // ############  处理上传文件 end #############

  // ############  处理上传多个文件 begin #############
  const handleChange: UploadProps['onChange'] = (file: UploadFile, files: UploadFiles) => {
    // console.log('handleChange file =', file.name)
    // console.log(files)
  }

  const handleRemoveFileMuti = (file: UploadFile, files: UploadFiles) => {
    console.log('移除文件: ', file.name)
    console.log('移除文件后剩下: ', files)
    form.files.forEach((item: { name: string; size: number; path: string; url: string; box_range: {} }) => {
      if (item.name === file.name) {
        form.files.pop(item)
        console.log('form.files移除:', file.name)
        console.log('form.files还剩下', form.files)
      }
    })
    if (files.length == 0) {
      console.log('form.files全部移除, form.files=', form.files)
    }
  }

  const handleUploadExceedMuti: UploadProps['onExceed'] = (files) => {
    console.log('超出限制的文件：', files)
    ElMessage({
      message: '超出限制的文件数',
      type: 'error'
    })
  }

  const handleBeforeUploadMuti = (file: any) => {
    console.log('上传文件：', file.name)
    const isLimit = file.size / 1024 / 1024 <= FileSizeLimitM
    if (!isLimit) {
      ElMessage.error('上传文件大小不能超过 '+FileSizeLimitM+'MB!')
      return false
    }
  }

  const handleUploadMuti = () => {
    // 提交上传
    upload.value!.submit()
  }

  const handleUploadSuccessMuti = (val: Wm.UploadResult, file: UploadFile, files: UploadFiles) => {
    // console.log(val)
    if (val.code == 0) {
      form.files.push({
        name: file.name,
        size: file.size,
        path: val.data[0].path,
        url: val.data[0].url,
        box_range: {},
      })
      ElMessage({
        message: file.name + ' 上传成功',
        type: 'success'
      })
      console.log('上传成功(', form.files.length, '), form.files=', form.files)
    } else {
      ElMessage({
        message: file.name + ' 上传失败：' + val.message,
        type: 'error'
      })
    }
  }

  // ############  处理上传多个文件 end #############


  return {
    loading,
    upload,
    actionUrl,
    handleChange,
    handleBeforeUpload,
    handleUploadSuccess,
    handleUploadExceed,
    handleUploadError,
    handleUploadProgress,
    handleRemoveFile,
    handleRemoveFileMuti,
    handleUploadExceedMuti,
    handleBeforeUploadMuti,
    handleUploadMuti,
    handleUploadSuccessMuti,
  }
}
