import { createRouter, createWebHashHistory } from 'vue-router'
import HomeView from '../views/home/index.vue'
import SampleHandleView from '../views/sample_handle/index.vue'
import WmNanoBananaView from '../views/wm_nano_banana/index.vue'
import SampleHandleViewV2 from '../views/sample_handle_v2/index.vue'
import AgentChatView from '../views/agent_chat/index.vue'


const router = createRouter({
  history: createWebHashHistory(import.meta.env.BASE_URL),
  routes: [
    {
      path: '/',
      name: 'home',
      component: AgentChatView
    },
    {
      path: '/report',
      name: 'report',
      component: HomeView
    },
    {
      path: '/sample_handle',
      name: 'sample_handle',
      component: SampleHandleView
    },
    {
      path: '/wm_nano_banana',
      name: 'wm_nano_banana',
      component: WmNanoBananaView
    },
    {
      path: '/sample_handle_v2',
      name: 'sample_handle_v2',
      component: SampleHandleViewV2
    },
    {
      path: '/agent_chat',
      name: 'agent_chat',
      component: AgentChatView
    },
  ]
})

export default router
