import aitoolsService from '@/api/service/aitoolsService'
import utils from '@/utils/utils'
import {
  ElMessage,
  ElLoading,
  ElMessageBox
} from 'element-plus'
import type { Action } from 'element-plus'
import { nextTick, ref } from 'vue'

export const onProcessing = (form: any, steps_active: any, process_loading: any, result_loading: any, dialogVisible: any) => {
    const fileToClassify = async () => {
        if (!form.file_path || form.file_path.length == 0) {
            ElMessage({
                message: '请先上传文件',
                type: 'warning'
            })
            return
        }
        // 进入第二页
        from_first_to_second();
        
        // 清除结果
        form.sample_result = {
            root_path: '',
            data: [{
                dir_name: '',
                images: [],
            }]
        };

        // 提交处理请求
        try {
            let param: any = {
                task_id: form.task_id,
                file_path: form.file_path,
                crop_range: JSON.stringify(form.crop_range),
                box_range: JSON.stringify(form.box_range),
                output_type: "dir",
                classes_select: "",
                target_fps: form.target_fps, // 目标帧率
                every_x_gen_dir: form.every_x_gen_dir, // 每多少图片生成一个目录
                slider_window: form.slider_window_2 ? 2 : 0, // 是否开启滑窗2张图
            }

            process_loading.value = true;
            
            // 发起请求
            aitoolsService.commonApi('提交处理', 'gen_sample_from_video', param)
            .then((response) => {
                // console.log(form)
                console.log(`接口返回：${response}`);
                form.sample_result = response;
                // 设置默认值
                form.classes_select = {}
                form.classes_select2 = {}
                response.data.forEach((item: { dir_name: string; images: string[] }) => {
                    form.classes_select[item.dir_name] = '0';
                    form.classes_select2[item.dir_name] = '';
                });
                process_loading.value = false;
            })
            .catch((error) => {
                ElMessage({
                    message: error,
                    type: 'error'
                });
                // // 重置task_id
                // form.task_id = utils.genDateTimeStr();
                // console.log('重置 task_id =', form.task_id);
                process_loading.value = false;
            })
        } catch (error: any) {
            ElMessage({
                message: error,
                type: 'error'
            });
            process_loading.value = false;
        }
    }

    function isAllDataClassified(): boolean {
        let is_ok = false;
        if (!form.sample_result?.data || !form.classes_select) {
            ElMessage({
                message: '数据未正确初始化',
                type: 'error'
            });
        }
        form.sample_result.data.every((item: { dir_name: string; images: string[] }) => {
            if (!form.classes_select.hasOwnProperty(item.dir_name)) {
                ElMessage({
                    message: `请为${item.dir_name}分类`,
                    type: 'error'
                });
            } else {
                is_ok = true
            }
        });
        return is_ok;
    }

    const gen_sample = async (param: any) => {
        result_loading.value = true;
        // 提交处理请求
        try {
            const response = await aitoolsService.commonApi('提交处理', 'gen_sample_from_video', param)
            console.log(`接口返回：${response}`);
            return response.sample_path;
        } catch (error: any) {
            ElMessage({
                message: error,
                type: 'error'
            });
        } finally {
            result_loading.value = false;
        }
    }

    const classifyToDownload = async () => {
        if (!isAllDataClassified()) {
            return
        }
        // 进入第3页
        from_second_to_third();
        // 清除结果
        form.sample_path = '';
        // 生成样本包
        let param: any = {
            task_id: form.task_id,
            file_path: form.file_path,
            crop_range: JSON.stringify(form.crop_range),
            box_range: JSON.stringify(form.box_range),
            output_type: "zip",
            classes_select: JSON.stringify(form.classes_select),
            target_fps: form.target_fps, // 目标帧率
        }
        form.sample_path = await gen_sample(param);
    }




    const from_first_to_second = () => {
        steps_active.value = 1
    }
    
    const back_to_first = () => {
        steps_active.value = 0;
        form.task_id = utils.genDateTimeStr();
        console.log('返回首页，task_id =', form.task_id);
    }

    const from_second_to_third = () => {
        steps_active.value = 2;
    }

    const back_to_second = () => {
        steps_active.value = 1;
        form.classes_select2 = JSON.parse(JSON.stringify(form.classes_select));
    }

    function downloadFile(url: string, filename?: string) {
        const a = document.createElement('a')
        a.href = url
        if (filename) {
            a.download = filename // 指定下载文件名
        }
        a.target = '_blank'
        document.body.appendChild(a)
        a.click()
        document.body.removeChild(a)
    }

    function deleteOneSample(sample_dir: string) {
        ElMessageBox.alert(`确认删除 ${sample_dir} 这行样本吗？`, '删除样本', {
            // autofocus: false,
            confirmButtonText: '删除',
            callback: (action: Action) => {
                if (action === 'confirm') {
                    // 删除 form.sample_result.data
                    const index = form.sample_result.data.findIndex((item: any) => item.dir_name === sample_dir);
                    form.sample_result.data.splice(index, 1);
                    // 删除 form.classes_select[sample_dir]
                    delete form.classes_select[sample_dir];
                    // 删除 form.classes_select2[sample_dir]
                    delete form.classes_select2[sample_dir];
                    
                    ElMessage({
                        type: 'success',
                        message: '删除成功'
                    })
                }
            },
        })
    }

    
    const checkSampleVideo = async (dir_name: string) => {
        // 提交处理请求
        try {
            let param: any = {
                task_id: form.task_id,
                file_path: form.file_path,
                dir_name: dir_name,
            }
            process_loading.value = true;
            // 发起请求
            const response = await aitoolsService.commonApi('提交处理', 'gen_clip_from_dirname', param);
            console.log(`接口返回：${response}`);
            process_loading.value = false;
            dialogVisible.value = true;
            // 使用 nextTick 等待 DOM 更新完成
            await nextTick();
            const clipVideo = document.getElementById('clip-video') as HTMLVideoElement;
            console.log(clipVideo);
            if (clipVideo && typeof response === 'string' && response.startsWith('http')) {
                clipVideo.src = response;
            } else {
                ElMessage({
                    message: response as string,
                    type: 'error'
                });
            }
        } catch (error: any) {
            ElMessage({
                message: error as string,
                type: 'error'
            });
            process_loading.value = false;
        }
    }

    const onCheckedListChange = (newValue: any) => {
        // console.log('CheckedList changed:', newValue);
        console.log('CheckedList changed:', form.checkedList);
    }

    function deleteMutiSample() {
        ElMessageBox.alert(`确认删除所选的这些样本吗？共${form.checkedList.length}行`, '批量删除样本', {
            // autofocus: false,
            confirmButtonText: '删除',
            callback: (action: Action) => {
                if (action === 'confirm') {
                    form.checkedList.forEach((sample_dir: string) => {
                        // 删除 form.sample_result.data
                        const index = form.sample_result.data.findIndex((item: any) => item.dir_name === sample_dir);
                        form.sample_result.data.splice(index, 1);
                        // 删除 form.classes_select[sample_dir]
                        delete form.classes_select[sample_dir];
                        // 删除 form.classes_select2[sample_dir]
                        delete form.classes_select2[sample_dir];
                    })
                    // 清空已选择列表
                    form.checkedList = [];
                    ElMessage({
                        type: 'success',
                        message: '删除成功'
                    })
                }
            },
        })
    }


    return {
        from_first_to_second,
        back_to_first,
        from_second_to_third,
        back_to_second,
        fileToClassify,
        classifyToDownload,
        downloadFile,
        process_loading,
        result_loading,
        deleteOneSample,
        checkSampleVideo,
        onCheckedListChange,
        deleteMutiSample,
        gen_sample,
    }
}