export default class utils {
  // 格式化为json字符串
  static formatJson(jsonString: string) {
    try {
      return JSON.stringify(JSON.parse(jsonString), null, 2); // 对JSON字符串进行格式化处理
    } catch (error) {
      return 'Invalid JSON'
    }
  }

  // 格式化为json
  static formatJsonObj(jsonString: string) {
    try {
      return JSON.parse(jsonString) // 对JSON字符串进行格式化处理
    } catch (error) {
      return JSON.parse('{"error": "Invalid JSON"}')
    }
  }

  // 生成年月日时分秒毫秒字符串
  static genDateTimeStr() {
    const now = new Date();
    const year = now.getFullYear();
    const month = (now.getMonth() + 1).toString().padStart(2, '0');
    const day = now.getDate().toString().padStart(2, '0');
    const hours = now.getHours().toString().padStart(2, '0');
    const minutes = now.getMinutes().toString().padStart(2, '0');
    const seconds = now.getSeconds().toString().padStart(2, '0');
    const milliseconds = now.getMilliseconds().toString().padStart(3, '0');
    const formattedDateTime = `${year}${month}${day}${hours}${minutes}${seconds}${milliseconds}`;
    // console.log(formattedDateTime); // 输出类似：20221231120530123
    return formattedDateTime
  }

  // 拆分文本
  static splitText(str: string) {
    str = str.replaceAll('“','').replaceAll('”','')
    // 使用正则表达式拆分文本
    let sentences = str.split(/[！|？|。|!|?]/);
    // 过滤掉长度为 0 的句子
    sentences = sentences.filter(s => s.length > 0);
    // 过滤掉只包含标点符号的句子
    sentences = sentences.filter(s => !utils.containsOnlyPunctuation(s));
    // console.log(sentences)
    return sentences
  }

  // 拆分英文文本
  static splitTextEn(str: string) {
    str = str.replaceAll('"','').replaceAll('"','')
    // 使用正则表达式拆分文本
    let sentences = str.split(/[!|?|.]/);
    // 过滤掉长度为 0 的句子
    sentences = sentences.filter(s => s.length > 0);
    // console.log(sentences)
    return sentences
  }

  // 过滤掉中文字符
  static filterChineseAndPunctuation(inputString: string) {
    return inputString.replace(/[\u4E00-\u9FA5\u3000-\u303F\uff00-\uffef]/g, '') // 过滤中文字符
                      .replace(/[^\w\s]|_/g, '') // 过滤标点符号
                      .replace(/\s+/g, ' '); // 连续多个空格替换为一个空格
  }

  // 检查该字符串是否只包含中文标点符号和英文标点符号
  static containsOnlyPunctuation(str: string) {
    // 使用正则表达式匹配是否只包含标点符号（包括中文标点）
    return /^[!-\/:-@\[-`{-~\p{P}\p{S}\s]*$/u.test(str);
  }

}
