/**
 * 相关接口
 */
import request from '@/api/request'

export default {
  submitGpt(prompt: string, llm: string = "gpt"): Promise<string> {
    if (!prompt) {
      return Promise.reject("输入不能为空");
    }
    const post_data = { source_text: prompt, llm: llm }
    return request.post('/text2video/text2gpt', post_data)
      .then((res: any) => {
        // console.log(res);
        if (res && res.code === 0) {
          return res.data.result.answer;
        } else {
          const errorMessage = res ? res.message : "未知错误";
          return Promise.reject(errorMessage);
        }
      })
      .catch((err: any) => {
        console.log(err);
        return Promise.reject("与LLM通讯失败");
      });
  },

  submitSD(
    task_id: string = "",
    img_idx: string = "",
    prompt: string = "",
    negative_prompt: string = "",
    width: string = "960",
    height: string = "512",
    sampler_index: string = "DPM++ 2M Karras",
    seed: string = "-1",
    steps: string = "25",
    cfg_scale: string = "9",
  ): Promise<{"domain_image_path": string, "local_image_path": string}> {
    if (!prompt) {
      return Promise.reject("SD提示词不能为空");
    }
    const post_data = {
      task_id: task_id,
      img_idx: img_idx,
      prompt: prompt,
      negative_prompt: negative_prompt,
      sampler_index: sampler_index,
      seed: seed,
      steps: steps,
      width: width,
      height: height,
      cfg_scale: cfg_scale,
    }
    return request.post('/text2video/text2img', post_data)
      .then((res: any) => {
        // console.log(res);
        if (res && res.code === 0) {
          return {"domain_image_path": res.data.result.domain_image_path, "local_image_path": res.data.result.local_image_path};
        } else {
          const errorMessage = res ? res.message : "未知错误";
          return Promise.reject(errorMessage);
        }
      })
      .catch((err: any) => {
        console.log(err);
        return Promise.reject("与 stable-diffusion-webui Api 通讯失败");
      });
  },

  submitGenVideo(gen_video_param: any): Promise<string> {
    if (!gen_video_param) {
      return Promise.reject("输入不能为空");
    }
    const post_data = gen_video_param
    return request.post('/text2video/gen_video', post_data)
      .then((res: any) => {
        // console.log(res);
        if (res && res.code === 0) {
          return res.data.result;
        } else {
          const errorMessage = res ? res.message : "未知错误";
          return Promise.reject(errorMessage);
        }
      })
      .catch((err: any) => {
        console.log(err);
        return Promise.reject("gen_video接口通讯失败");
      });
  },
}
