export function calcAdapt() {
  const maxScale = 2.16
  const minScale = 1.78
  const dot = 2
  const { scale } = getSystemInfo()
  return {
    calcCoord: function ({ minTop, maxTop }, currentScale = scale) {
      if (!currentScale) return {
        top: maxTop
      }
      const s = +((currentScale - minScale) / (maxScale - minScale)).toFixed(dot)
      const top = (maxTop - minTop) * s + minTop
      return {
        top
      }
    },
    calc: function ({
      minWidth, minHeight, maxWidth, maxHeight
    }, currentScale = scale) {
      if (!currentScale) return
      // 1.78 
      // 2.16
      let width, height;
      // (minWidth / maxWidth)
      // 比例因子
      const s = +((currentScale - minScale) / (maxScale - minScale)).toFixed(dot)
      width = (maxWidth - minWidth) * s + minWidth
      height = (maxHeight - minHeight) * s + minHeight
      return {
        width,
        height,
      }
    }
  }
}

export const isBigScreen = () => {
  let width = 0;
  let height = 0;
  if (!isMobile()) {
    width = 750;
    height = document.body.clientHeight > 1334 ? document.body.clientHeight : 1334;
  } else {
    width = document.body.clientWidth;
    height = document.body.clientHeight;
  }
  if (height === 0) {
    height = window.innerHeight;
    if (!isMobile()) {
      height = window.innerHeight > 1334 ? window.innerHeight : 1334;
    }
  }
  let scale = height / width;
  let k = +scale.toFixed(2);
  if (k >= 2.16) {
    k = 2.16;
  } else if (k <= 1.78) {
    k = 1.78;
  }
  if (k > 1.78) return true
  return false
}

export const getSystemInfo = () => {
  let width = 0;
  let height = 0;
  if (!isMobile()) {
    width = 750;
    height = document.body.clientHeight > 1334 ? document.body.clientHeight : 1334;
  } else {
    width = document.body.clientWidth;
    height = document.body.clientHeight;
  }

  if (height === 0) {
    height = window.innerHeight;
    if (!isMobile()) {
      height = window.innerHeight > 1334 ? window.innerHeight : 1334;
    }
  }
  let scale = height / width;

  return {
    windowWidth: width,
    windowHeight: height,
    screenWidth: width,
    screenHeight: height,
    scale: scale
  }
}
export const authCamera = (lying) => {
  const that = this;
  return new Promise((resolve, reject) => {
    if (navigator.mediaDevices === undefined) {
      navigator.mediaDevices = {};
    }

    if (navigator.mediaDevices.getUserMedia === undefined) {
      navigator.mediaDevices.getUserMedia = function (constraints) {
        // 首先获取现存的getUserMedia(如果存在)
        let getUserMedia =
          navigator.webkitGetUserMedia ||
          navigator.mozGetUserMedia ||
          navigator.getUserMedia;
        if (!getUserMedia) {
          return Promise.reject(
            new Error("getUserMedia is not implemented in this browser")
          );
        }
        return new Promise(function (resolve, reject) {
          getUserMedia.call(navigator, constraints, resolve, reject);
        });
      };
    }

    const constraints = {
      audio: false,
      video: {
        transform: "scaleX(-1)"
      }
    };

    navigator.mediaDevices
      .getUserMedia(constraints)
      .then(function (stream) {
        resolve({ camera: 1, lying })
      })
      .catch(err => {
        console.log("没有开启摄像头权限或浏览器版本不兼容");
        console.log('获取用户授权信息失败')
      });
  })
}

export const isMobile = () => {
  let flag = navigator.userAgent.match(
    /(phone|pad|pod|iPhone|iPod|ios|iPad|Android|Mobile|BlackBerry|IEMobile|MQQBrowser|JUC|Fennec|wOSBrowser|BrowserNG|WebOS|Symbian|Windows Phone)/i
  );
  return flag;
}