import {
  defineConfig
} from 'vite'
import vue from '@vitejs/plugin-vue'
import postcss100vhFix from 'postcss-100vh-fix'

const config = require('./config')

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [vue()],
  css: {
    postcss: {
      plugins: [
        postcss100vhFix,
      ]
    }
  },
  base: config.base,
  resolve: config.resolve,
  server: {
    proxy: config.proxy,
    port: config.port
  },
})