package com.ypsx.yppos.http.data.bean

import java.io.Serializable

/**
 *  分页数据的基类
 */
data class ApiPagerResponse<T>(
    var page: Int,//当前页数
    var pageSize: Int,//每页记录数，必须大于0且小于等于100
    var pageCount: Int,//总页数
    var records: T,
    var recordCount: Int//总记录数
) : Serializable {
    /**
     * 数据是否为空
     */
    fun isEmpty() = (records as List<*>).size == 0

    /**
     * 是否为刷新
     */
    fun isRefresh() = page == 1

    /**
     * 是否还有更多数据
     */
    fun hasMore() = page * pageSize < recordCount
}