package com.ypsx.yppos.room.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import com.ypsx.yppos.room.entity.PosProduct

@Dao
interface PosProductDao {

    @Query("SELECT * from POS_Product WHERE (barCode=:key OR productNumber=:key OR mnemonicCode=:key) AND shelvesStatus='ON' LIMIT 0,1")
    fun queryKeyWords(key: String): PosProduct?

    @Query("SELECT * from POS_Product WHERE mnemonicCode=:mnemonicCode AND shelvesStatus='ON'  LIMIT 0,1")
    fun queryByMnemonicCode(mnemonicCode: String): PosProduct?

    @Query("SELECT * from POS_Product WHERE id IN (:productId)")
    fun queryAllByProductId(productId: ArrayList<String>): List<PosProduct>

    @Query("SELECT id from POS_Product WHERE barCode=:key OR productNumber=:key OR mnemonicCode=:key LIMIT 0,1")
    fun queryKeyWords2(key: String): String?

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insertAll(vararg list: PosProduct?)


    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insert(posProduct: PosProduct?)

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    fun insertList(list: List<PosProduct>?)


}