package com.ypsx.yppos.ui.popup

import android.app.Activity
import android.content.Context
import android.view.Gravity
import android.view.View
import android.view.animation.Animation
import com.ypsx.base.base.appContext
import com.ypsx.base.ext.util.screenWidth
import com.ypsx.yppos.R
import com.ypsx.yppos.databinding.PopupPayAmountBinding
import com.ypsx.yppos.http.data.entity.PosPayMethod
import com.ypsx.yppos.utils.CacheUtil
import com.ypsx.yppos.utils.dXLog
import com.ypsx.yppos.viewmodel.state.PayAmountViewModel
import razerdp.basepopup.BasePopupWindow
import razerdp.util.animation.AnimationHelper
import razerdp.util.animation.TranslationConfig
import java.util.*


class PayAmountPopupWindow(context: Context) : BasePopupWindow(context) {
    companion object {
        var state: Boolean = true
    }

    var binding: PopupPayAmountBinding? = null
    lateinit var activity: Activity
    lateinit var payMethod: PosPayMethod
    var timer: Timer? = null
    var task: TimerTask? = null
    var recLen = 60


    init {
        setContentView(R.layout.popup_pay_amount)
        width = appContext.screenWidth / 4 * 3
        popupGravity = Gravity.CENTER


    }

    override fun onViewCreated(contentView: View) {
        binding = PopupPayAmountBinding.bind(contentView)
        binding?.vm = PayAmountViewModel()
        binding?.click = ProxyClick()
        activity = context

    }

    override fun onCreateShowAnimation(): Animation {
        return AnimationHelper.asAnimation()
            .withTranslation(TranslationConfig.FROM_BOTTOM)
            .toShow()
    }

    override fun onCreateDismissAnimation(): Animation {
        return AnimationHelper.asAnimation()
            .withTranslation(TranslationConfig.TO_BOTTOM)
            .toDismiss()
    }


    fun setData(payMethod: PosPayMethod, amount: String) {
        binding?.vm?.amount?.set(amount)
        this.payMethod = payMethod
        state = true
        var title = ""

        when (payMethod) {
            PosPayMethod.CCB_BAR_PAY -> {
                title = "扫码支付"
                binding?.vm?.payTitle?.set("扫码支付")
                binding?.vm?.payTips?.set("扫描消费者出示的付款码")
            }
            PosPayMethod.CARDPAY -> {
                title = "会员余额"
                binding?.vm?.payTitle?.set("会员余额")
                binding?.vm?.payTips?.set("扫描用户出示的会员付款码")
            }
            else -> {
                dismiss()
            }
        }
        "${CacheUtil.getRealName()}打开${title}，应收款：¥${amount}".dXLog()

    }


    @JvmName("getPayMethod1")
    fun getPayMethod(): PosPayMethod {
        return payMethod
    }

    fun setShowTimer() {
        recLen = 60
        state = false
        timer = Timer()
        binding?.vm?.tipsShow?.set(false)
        binding?.vm?.timeText?.set("${recLen}s")
        task = object : TimerTask() {
            override fun run() {
                recLen--
                if (recLen < 0) {
                    state = true
                    activity.runOnUiThread {
                        payAction.invoke()
                        binding?.vm?.timeText?.set("0s")
                    }
                } else {
                    binding?.vm?.timeText?.set("${recLen}s")
                }

                if (recLen < 0) {
                    stopTimer()
                }
            }
        }
        timer?.schedule(task, 1000, 1000);

    }

    private fun stopTimer() {
        if (timer != null && task != null) {
            timer?.cancel()
            timer?.purge()
            timer = null
            task = null
        }
    }

    fun timeIsFinish(): Boolean {
        return recLen <= 0
    }

    fun timeIsStart(): Boolean {
        return binding?.vm?.tipsShow?.get() ?: true
    }

    override fun dismiss() {
        super.dismiss()
        stopTimer()
    }

    private var payAction: () -> Unit =
        { }

    fun setFinishClick(payAction: () -> Unit) {
        this.payAction = payAction
    }


    inner class ProxyClick {
        fun close() {
            dismiss()
        }

    }

}