package com.ypsx.yppos.utils

import java.text.DateFormat
import java.text.SimpleDateFormat
import java.util.*

const val DATE_FORMATTER_2 = "yyyy-MM-dd"
const val DATE_FORMATTER_11 = "yyyy-MM-dd HH:mm:ss.SSS"
const val DATE_FORMATTER_3 = "yyyy-MM-dd HH:mm:ss"
const val DATE_FORMATTER = "yyMMddHHmmss"
object DateUtil {
    /**
     * 返回当前日期的字符串格式
     */
    fun getTodayDate(): String {
        val date = Date()
        val df: DateFormat = SimpleDateFormat(DATE_FORMATTER_2, Locale.CHINA)
        return df.format(date)
    }

    fun getLogTime(time: Long): String? {
        val date = Date(time)
        val sdf = SimpleDateFormat(DATE_FORMATTER_11, Locale.CHINA)
        return sdf.format(date)
    }

    fun getOrderDate():String {
        val date = Date()
        val df: DateFormat = SimpleDateFormat(DATE_FORMATTER, Locale.CHINA)
        return df.format(date)
    }

    fun getTodayDateTime(): String {
        val date = Date()
        val df: DateFormat = SimpleDateFormat(DATE_FORMATTER_3, Locale.CHINA)
        return df.format(date)
    }
}