package com.ypsx.yppos.utils.scan

import android.os.Handler
import android.view.KeyEvent
const val MESSAGE_DELAY: Long = 500 //延迟500ms，判断扫码是否完成。
class ScanGunKeyEventHelper {

    //扫码内容
    private val mStringBufferResult = StringBuffer()

    //大小写区分
    private var mCaps = false
    private var mOnScanSuccessListener: OnScanSuccessListener? = null
    private val mHandler = Handler()

    private val mScanningFishedRunnable = Runnable { performScanSuccess() }

    /**
     * 返回扫描结果
     */
    private fun performScanSuccess() {
        val barcode = mStringBufferResult.toString()
        if (mOnScanSuccessListener != null) mOnScanSuccessListener!!.onScanSuccess(barcode)
        mStringBufferResult.setLength(0)
    }

    /**
     * key事件处理
     */
    fun analysisKeyEvent(event: KeyEvent) {
        val keyCode = event.keyCode
        //字母大小写判断
        checkLetterStatus(event)
        if (event.action == KeyEvent.ACTION_DOWN) {
            val aChar = getInputCode(event)
            if (aChar.toInt() != 0) {
                mStringBufferResult.append(aChar)
            }
            if (keyCode == KeyEvent.KEYCODE_ENTER) {
                //若为回车键，直接返回
                mHandler.removeCallbacks(mScanningFishedRunnable)
                mHandler.post(mScanningFishedRunnable)
            } else {
                //延迟post，若500ms内，有其他事件
                mHandler.removeCallbacks(mScanningFishedRunnable)
                mHandler.postDelayed(mScanningFishedRunnable, MESSAGE_DELAY)
            }
        }
    }

    /**
     * 检查shift键
     */
    private fun checkLetterStatus(event: KeyEvent) {
        val keyCode = event.keyCode
        if (keyCode == KeyEvent.KEYCODE_SHIFT_RIGHT || keyCode == KeyEvent.KEYCODE_SHIFT_LEFT) {
            mCaps = event.action == KeyEvent.ACTION_DOWN
        }
    }


    /**
     * 获取扫描内容
     */
    private fun getInputCode(event: KeyEvent): Char {
        val keyCode = event.keyCode
        val aChar: Char
        aChar = if (keyCode >= KeyEvent.KEYCODE_A && keyCode <= KeyEvent.KEYCODE_Z) {
            //字母
            ((if (mCaps) 'A' else 'a').toInt() + keyCode - KeyEvent.KEYCODE_A).toChar()
        } else if (keyCode >= KeyEvent.KEYCODE_0 && keyCode <= KeyEvent.KEYCODE_9) {
            //数字
            ('0'.toInt() + keyCode - KeyEvent.KEYCODE_0).toChar()
        } else {
            //其他符号
            when (keyCode) {
                KeyEvent.KEYCODE_PERIOD -> '.'
                KeyEvent.KEYCODE_MINUS -> if (mCaps) '_' else '-'
                KeyEvent.KEYCODE_SLASH -> '/'
                KeyEvent.KEYCODE_BACKSLASH -> if (mCaps) '|' else '\\'
                else -> 0.toChar()
            }
        }
        return aChar
    }

    /**
     * 定义监听回调接口
     */
    interface OnScanSuccessListener {
        fun onScanSuccess(barcode: String)
    }

    fun setOnBarCodeCatchListener(onScanSuccessListener: OnScanSuccessListener?) {
        mOnScanSuccessListener = onScanSuccessListener
    }

    fun onDestroy() {
        mHandler.removeCallbacks(mScanningFishedRunnable)
        mOnScanSuccessListener = null
    }
}